<?php

use App\Http\Controllers\Supervision\LoginController;
use App\Http\Controllers\Supervision\VisitController;
use App\Http\Controllers\Supervision\ReportController;
use App\Http\Controllers\Supervision\FeedbackController;
use App\Http\Controllers\Supervision\MemberController;
use App\Http\Controllers\Supervision\TownshipController;



Route::prefix("supervision")->group(function () {
    Route::post('/login', [LoginController::class, 'login']);

    Route::middleware('auth:members-api')->group(function () {
        Route::prefix("your")->group(function () {
            Route::get('/', [LoginController::class, 'getYour']);
        });

        Route::prefix("members")->group(function () {
            Route::get('/get', [MemberController::class, 'get']);
        });

        Route::prefix("townships")->group(function () {
            Route::get('/get', [TownshipController::class, 'get']);
        });

        Route::prefix("visits")->group(function () {
            Route::post('/store', [VisitController::class, 'store']);
            Route::post('/update', [VisitController::class, 'update']);
            Route::post('/delete', [VisitController::class, 'delete']);
            Route::get('/get', [VisitController::class, 'get']);
            Route::get('/getEach', [VisitController::class, 'getEach']);

            Route::prefix("report")->group(function () {
                Route::get('/', [ReportController::class, 'get']);
            });

            Route::prefix("feedback")->group(function () {
                Route::post('/store', [FeedbackController::class, 'store']);
                Route::post('/update', [FeedbackController::class, 'update']);
                Route::post('/delete', [FeedbackController::class, 'delete']);
                Route::get('/get', [FeedbackController::class, 'get']);
                Route::get('/getEach', [FeedbackController::class, 'getEach']);
            });
        });
    });
});
