<?php

use App\Http\Controllers\PA\LoginController;
use App\Http\Controllers\PA\VolunteerController;
use App\Http\Controllers\PA\VolunteerTrainingController;
use App\Http\Controllers\PA\PatientController;
use App\Http\Controllers\PA\PreEnrollSupportController;
use App\Http\Controllers\PA\EnrollSupportController;
use App\Http\Controllers\PA\TownshipController;
use App\Http\Controllers\PA\HeActivityController;
use App\Http\Controllers\PA\HomeVisitActivityController;
use App\Http\Controllers\PA\SupervisionVisitActivityController;
use App\Http\Controllers\PA\CounselingActivityController;
use App\Http\Controllers\PA\PatientMDRTBRegimentController;
use App\Http\Controllers\PA\ReferPatientController;
use App\Http\Controllers\PA\FamilyMemberController;
use App\Http\Controllers\PA\PresumptiveController;
use App\Http\Controllers\PA\DelagatedPersonController;
use App\Http\Controllers\PA\OutsideTownshipController;
use App\Http\Controllers\PA\DOTSPatientController;
use App\Http\Controllers\PA\DOTSActivityController;
use App\Http\Controllers\PA\DOTSVolunteerController;
use App\Http\Controllers\PA\DOTSVisitReportController;
use App\Http\Controllers\PA\ReportController;
use App\Http\Controllers\DA\BasicDataController;




Route::prefix("pa")->group(function () {
    // Route::get('/activity/he/export', [HeActivityController::class, 'export']);
    Route::post('/login', [LoginController::class, 'login']);
    Route::middleware('auth:pas-api')->group(function () {
        Route::prefix("your")->group(function () {
            Route::get('/', [LoginController::class, 'getYour']);
            Route::post('/changePassword', [LoginController::class, 'changePassword']);
        });

         Route::prefix("basic_data")->group(function () {
            Route::get('/get', [BasicDataController::class, 'get']);
        });
        
        Route::prefix("delagated_person")->group(function () {
            Route::post('/store', [DelagatedPersonController::class, 'store']);
            Route::get('/get', [DelagatedPersonController::class, 'get']);
            Route::get('/getEach', [DelagatedPersonController::class, 'getEach']);
            Route::post('/update', [DelagatedPersonController::class, 'update']);
            Route::post('/delete', [DelagatedPersonController::class, 'delete']);
            //Route::post('/savePresumptive', [DelagatedPersonController::class, 'savePresumptive']);
        });

        Route::prefix("volunteer")->group(function () {
            Route::post('/store', [VolunteerController::class, 'store']);
            Route::get('/get', [VolunteerController::class, 'get']);
            Route::get('/getEach', [VolunteerController::class, 'getEach']);
            Route::post('/update', [VolunteerController::class, 'update']);
            Route::post('/delete', [VolunteerController::class, 'delete']);
            Route::get('/trash', [VolunteerController::class, 'trash']);
            Route::post('/recover', [VolunteerController::class, 'recover']);

            Route::prefix("trainings")->group(function () {
                Route::post('/store', [VolunteerTrainingController::class, 'store']);
                Route::post('/delete', [VolunteerTrainingController::class, 'delete']);
                Route::get('/get', [VolunteerTrainingController::class, 'get']);
            });
        });

        Route::prefix("township")->group(function () {

            Route::get('/get', [TownshipController::class, 'get']);
            Route::get('/get-all', [TownshipController::class, 'getAll']);
        });

        Route::prefix("outside_township")->group(function () {

            Route::get('/get', [OutsideTownshipController::class, 'get']);
        });

        Route::prefix("patient")->group(function () {
            Route::post('/store', [PatientController::class, 'store']);
            Route::get('/get', [PatientController::class, 'get']);
            Route::get('/get_patients_by_township', [PatientController::class, 'getPatientsByTownship']);
            Route::get('/getEach', [PatientController::class, 'getEach']);
            Route::post('/update', [PatientController::class, 'update']);
            Route::post('/delete', [PatientController::class, 'delete']);
            Route::get('/export', [PatientController::class, 'export']);
            Route::get('/get_patients_by_township', [PatientController::class, 'getPatientsByTownship']);
            
            Route::post('/app_refer_action', [PatientController::class, 'apprefer']);
          
            Route::prefix("mdrtb_regiment")->group(function () {
                Route::post('/store', [PatientMDRTBRegimentController::class, 'store']);
                Route::post('/delete', [PatientMDRTBRegimentController::class, 'delete']);
                Route::get('/get', [PatientMDRTBRegimentController::class, 'get']);
            });

            Route::prefix("pre_enroll")->group(function () {
                Route::prefix("support")->group(function () {
                    Route::post('/store', [PreEnrollSupportController::class, 'store']);
                    Route::post('/update', [PreEnrollSupportController::class, 'update']);
                    Route::get('/get', [PreEnrollSupportController::class, 'get']);
                    Route::get('/getEach', [PreEnrollSupportController::class, 'getEach']);
                    Route::post('/delete', [PreEnrollSupportController::class, 'delete']);
                });
            });

            Route::prefix("enroll")->group(function () {
                Route::prefix("support")->group(function () {
                    Route::post('/store', [EnrollSupportController::class, 'store']);
                    Route::post('/update', [EnrollSupportController::class, 'update']);
                    Route::get('/get', [EnrollSupportController::class, 'get']);
                    Route::get('/getEach', [EnrollSupportController::class, 'getEach']);
                    Route::post('/delete', [EnrollSupportController::class, 'delete']);
                });

                Route::prefix("information")->group(function () {
                    Route::post('/update', [EnrollSupportController::class, 'updateInformation']);
                });

                Route::prefix("finish_information")->group(function () {
                    Route::post('/update', [EnrollSupportController::class, 'updateFinishInformation']);
                });
            });
        });

        Route::prefix("activity")->group(function () {
            
            Route::prefix("he")->group(function () {
                Route::get('/get', [HeActivityController::class, 'get']);
                Route::get('/getUncompletedList', [HeActivityController::class, 'getUncompletedList']);
                Route::get('/getEach', [HeActivityController::class, 'getEach']);
                Route::post('/store', [HeActivityController::class, 'store']);
                Route::post('/update', [HeActivityController::class, 'update']);
                Route::post('/delete', [HeActivityController::class, 'delete']);
            });

            Route::prefix("home_visit")->group(function () {
                Route::get('/get', [HomeVisitActivityController::class, 'get']);
                 Route::post('/check-code', [HomeVisitActivityController::class, 'checkcode']);
                Route::get('/update-month', [HomeVisitActivityController::class, 'updateMonthData']);
                Route::get('/getUncompletedList', [HomeVisitActivityController::class, 'getUncompletedList']);
                Route::get('/getEach', [HomeVisitActivityController::class, 'getEach']);
                Route::post('/store', [HomeVisitActivityController::class, 'store']);
                Route::post('/update', [HomeVisitActivityController::class, 'update']);
                Route::post('/delete', [HomeVisitActivityController::class, 'delete']);
            });



            Route::prefix("supervision_visit")->group(function () {
                Route::get('/get', [SupervisionVisitActivityController::class, 'get']);
                Route::get('/getUncompletedList', [SupervisionVisitActivityController::class, 'getUncompletedList']);
                Route::get('/getEach', [SupervisionVisitActivityController::class, 'getEach']);
                Route::post('/store', [SupervisionVisitActivityController::class, 'store']);
                Route::post('/update', [SupervisionVisitActivityController::class, 'update']);
                Route::post('/delete', [SupervisionVisitActivityController::class, 'delete']);
            });

            Route::prefix("counseling")->group(function () {
                Route::get('/get', [CounselingActivityController::class, 'get']);
                Route::get('/getUncompletedList', [CounselingActivityController::class, 'getUncompletedList']);
                Route::get('/getEach', [CounselingActivityController::class, 'getEach']);
                Route::post('/store', [CounselingActivityController::class, 'store']);
                Route::post('/update', [CounselingActivityController::class, 'update']);
                Route::post('/delete', [CounselingActivityController::class, 'delete']);
            });
        });

        Route::prefix("family_member")->group(function () {
            Route::post('/store', [FamilyMemberController::class, 'store']);
            Route::get('/get', [FamilyMemberController::class, 'get']);
            Route::get('/getEach', [FamilyMemberController::class, 'getEach']);
            Route::post('/update', [FamilyMemberController::class, 'update']);
            Route::post('/delete', [FamilyMemberController::class, 'delete']);
            Route::post('/savePresumptive', [FamilyMemberController::class, 'savePresumptive']);
        });

        Route::prefix("refer_patient")->group(function () {
            Route::post('/store', [ReferPatientController::class, 'store']);
            Route::get('/get', [ReferPatientController::class, 'get']);
            Route::get('/getEach', [ReferPatientController::class, 'getEach']);
            Route::post('/update', [ReferPatientController::class, 'update']);
            Route::post('/delete', [ReferPatientController::class, 'delete']);
            //Route::post('/savePresumptive', [ReferPatientController::class, 'savePresumptive']);
        });

        Route::prefix("presumptive")->group(function () {
            Route::get('/index_code', [PresumptiveController::class, 'searchByIndexCode']);
            Route::get('/get', [PresumptiveController::class, 'get']);
            Route::get('/getEach', [PresumptiveController::class, 'getEach']);
            Route::get('/refer/get', [PresumptiveController::class, 'getReferList']);
        });

        Route::prefix("report")->group(function () {
            Route::prefix("form7")->group(function () {
                Route::get('/get', [ReportController::class, 'getForm7Report']);
                Route::get('/export', [ReportController::class, 'exporForm7Report']);
            });

            Route::prefix("monthly")->group(function () {
                Route::get('/get', [ReportController::class, 'getMonthlyReport']);
            });

            Route::prefix("nomination")->group(function () {
                Route::get('/get', [ReportController::class, 'getNominationList']);
            });

            Route::prefix("nomination14A")->group(function () {
                Route::get('/get', [ReportController::class, 'getNominationList14A']);
            });
            
            Route::prefix("volunteer")->group(function () {
                Route::get('/reported', [ReportController::class, 'getReportedVolunteer']);
                Route::get('/dots/reported', [ReportController::class, 'getDOTSReportedVolunteer']);
                Route::get('/detail', [ReportController::class, 'getVolunteerDetailReport']);
                Route::get('/dots_patient', [ReportController::class, 'getDOTSPatient']);
                Route::get('/finished_dots_patient', [ReportController::class, 'getFinishedDOTSPatient']);
            });
        });

        Route::prefix("dots_patient")->group(function () {
            Route::post('/store', [DOTSPatientController::class, 'store']);
            Route::post('/update', [DOTSPatientController::class, 'update']);
            Route::post('/delete', [DOTSPatientController::class, 'delete']);
            Route::get('/get', [DOTSPatientController::class, 'get']);
            Route::get('/getEach', [DOTSPatientController::class, 'getEach']);

            Route::prefix("volunteer_activity")->group(function () {
                Route::get('/get', [DOTSVolunteerController::class, 'get']);
                Route::get('/getEach', [DOTSVolunteerController::class, 'getEach']);
                Route::post('/update', [DOTSVolunteerController::class, 'update']);
                Route::post('/store', [DOTSVolunteerController::class, 'store']);
                Route::post('/delete', [DOTSVolunteerController::class, 'delete']);
            });

            Route::prefix("visit_report")->group(function () {
                Route::get('/get', [DOTSVisitReportController::class, 'get']);
                Route::post('/store', [DOTSVisitReportController::class, 'store']);
                Route::post('/delete', [DOTSVisitReportController::class, 'delete']);
            });

            Route::prefix("visit_date")->group(function () {
                Route::post('/finish', [DOTSPatientController::class, 'finishVisitDate']);
                Route::get('/get', [DOTSPatientController::class, 'getVisitDate']);
            });

            Route::prefix("activity")->group(function () {
                Route::get('/get', [DOTSActivityController::class, 'get']);
                Route::get('/getEach', [DOTSActivityController::class, 'getEach']);
                Route::post('/update', [DOTSActivityController::class, 'update']);
                Route::post('/store', [DOTSActivityController::class, 'store']);
                Route::post('/delete', [DOTSActivityController::class, 'delete']);
            });
            
            Route::prefix("report")->group(function () {
            Route::prefix("form7")->group(function () {
                Route::get('/get', [ReportController::class, 'getForm7Report']);
                Route::get('/export', [ReportController::class, 'exporForm7Report']);
            });

            Route::prefix("monthly")->group(function () {
                Route::get('/get', [ReportController::class, 'getMonthlyReport']);
            });

            Route::prefix("volunteer")->group(function () {
                Route::get('/reported', [ReportController::class, 'getReportedVolunteer']);
                Route::get('/dots/reported', [ReportController::class, 'getDOTSReportedVolunteer']);
                Route::get('/detail', [ReportController::class, 'getVolunteerDetailReport']);
            });
        });
            
        });
    });
});
