<?php

use App\Http\Controllers\Dashboard\AdminLoginController;
use App\Http\Controllers\Dashboard\AdminController;
use App\Http\Controllers\Dashboard\TownshipGroupController;
use App\Http\Controllers\Dashboard\TownshipController;
use App\Http\Controllers\Dashboard\OutsideTownshipController;
use App\Http\Controllers\Dashboard\RegionController;
use App\Http\Controllers\Dashboard\PAController;
use App\Http\Controllers\Dashboard\DAController;
use App\Http\Controllers\Dashboard\MemberController;
use App\Http\Controllers\Dashboard\RiskFactorController;
use App\Http\Controllers\Dashboard\SymptonController;
use App\Http\Controllers\Dashboard\BasicDataController;
use App\Http\Controllers\Dashboard\VolunteerController;
use App\Http\Controllers\Dashboard\VolunteerTrainingController;
use App\Http\Controllers\Dashboard\LowSideEffectController;
use App\Http\Controllers\Dashboard\HighSideEffectController;
use App\Http\Controllers\Dashboard\PatientController;
use App\Http\Controllers\Dashboard\PreEnrollSupportController;
use App\Http\Controllers\Dashboard\EnrollSupportController;
use App\Http\Controllers\Dashboard\PatientMDRTBRegimentController;
use App\Http\Controllers\Dashboard\HeActivityController;
use App\Http\Controllers\Dashboard\HomeVisitActivityController;
use App\Http\Controllers\Dashboard\SupervisionVisitActivityController;
use App\Http\Controllers\Dashboard\CounselingActivityController;
use App\Http\Controllers\Dashboard\FamilyMemberController;
use App\Http\Controllers\Dashboard\ReferPatientController;
use App\Http\Controllers\Dashboard\PresumptiveController;
use App\Http\Controllers\Dashboard\DOTSPatientController;
use App\Http\Controllers\Dashboard\DOTSActivityController;
use App\Http\Controllers\Dashboard\DOTSVolunteerController;
use App\Http\Controllers\Dashboard\DOTSVisitReportController;
use App\Http\Controllers\Dashboard\ReportController;
use App\Http\Controllers\Dashboard\ClinicController;
use App\Http\Controllers\Dashboard\DataImportController;
use App\Http\Controllers\Dashboard\InnoDotController;


Route::prefix("dashboard")->group(function () {
    // Route::get('/patient/get', [PatientController::class, 'get']);
    
    Route::get('/activity/homevisit/export', [HomeVisitActivityController::class, 'export']);
    
    Route::get('/familymember/export', [PatientController::class, 'familymember_export']);
    Route::get('/ci/export', [PresumptiveController::class, 'ci_export']);
    
    Route::get('/patient/export', [PatientController::class, 'export']);
    Route::post('/login', [AdminLoginController::class, 'login']);

    Route::middleware('auth:admins-api')->group(function () {
        Route::prefix("your")->group(function () {
            Route::get('/', [AdminLoginController::class, 'getYour']);
            Route::post('/changePassword', [AdminLoginController::class, 'changePassword']);
        });

        Route::prefix("admin")->group(function () {
            Route::post('/store', [AdminController::class, 'store']);
            Route::get('/get', [AdminController::class, 'get']);
            Route::get('/getEach', [AdminController::class, 'getEach']);
            Route::post('/update', [AdminController::class, 'update']);
            Route::post('/delete', [AdminController::class, 'delete']);
        });

        Route::prefix("township_group")->group(function () {
            Route::post('/store', [TownshipGroupController::class, 'store']);
            Route::get('/get', [TownshipGroupController::class, 'get']);
            Route::get('/getEach', [TownshipGroupController::class, 'getEach']);
            Route::post('/update', [TownshipGroupController::class, 'update']);
            Route::post('/delete', [TownshipGroupController::class, 'delete']);
        });

        Route::prefix("region")->group(function () {
            Route::post('/store', [RegionController::class, 'store']);
            Route::get('/get', [RegionController::class, 'get']);
            Route::get('/getEach', [RegionController::class, 'getEach']);
            Route::post('/update', [RegionController::class, 'update']);
            Route::post('/delete', [RegionController::class, 'delete']);
        });

        Route::prefix("township")->group(function () {
            Route::post('/store', [TownshipController::class, 'store']);
            Route::get('/get', [TownshipController::class, 'get']);
            Route::get('/getEach', [TownshipController::class, 'getEach']);
            Route::post('/update', [TownshipController::class, 'update']);
            Route::post('/delete', [TownshipController::class, 'delete']);
        });

        Route::prefix("outside_township")->group(function () {
            Route::post('/store', [OutsideTownshipController::class, 'store']);
            Route::get('/get', [OutsideTownshipController::class, 'get']);
            Route::get('/getEach', [OutsideTownshipController::class, 'getEach']);
            Route::post('/update', [OutsideTownshipController::class, 'update']);
            Route::post('/delete', [OutsideTownshipController::class, 'delete']);
        });

        Route::prefix("pa")->group(function () {
            Route::post('/store', [PAController::class, 'store']);
            Route::get('/get', [PAController::class, 'get']);
            Route::get('/getEach', [PAController::class, 'getEach']);
            Route::post('/update', [PAController::class, 'update']);
            Route::post('/delete', [PAController::class, 'delete']);
        });

        Route::prefix("da")->group(function () {
            Route::post('/store', [DAController::class, 'store']);
            Route::get('/get', [DAController::class, 'get']);
            Route::get('/getEach', [DAController::class, 'getEach']);
            Route::post('/update', [DAController::class, 'update']);
            Route::post('/delete', [DAController::class, 'delete']);
        });

        Route::prefix("clinic")->group(function () {
            Route::post('/store', [ClinicController::class, 'store']);
            Route::get('/get', [ClinicController::class, 'get']);
            Route::get('/getEach', [ClinicController::class, 'getEach']);
            Route::post('/update', [ClinicController::class, 'update']);
            Route::post('/delete', [ClinicController::class, 'delete']);
        });

        Route::prefix("sympton")->group(function () {
            Route::post('/store', [SymptonController::class, 'store']);
            Route::get('/get', [SymptonController::class, 'get']);
            Route::get('/getEach', [SymptonController::class, 'getEach']);
            Route::post('/update', [SymptonController::class, 'update']);
            Route::post('/delete', [SymptonController::class, 'delete']);
        });

        Route::prefix("risk_factor")->group(function () {
            Route::post('/store', [RiskFactorController::class, 'store']);
            Route::get('/get', [RiskFactorController::class, 'get']);
            Route::get('/getEach', [RiskFactorController::class, 'getEach']);
            Route::post('/update', [RiskFactorController::class, 'update']);
            Route::post('/delete', [RiskFactorController::class, 'delete']);
        });


        Route::prefix("basic_data")->group(function () {
            Route::post('/store', [BasicDataController::class, 'store']);
            Route::get('/get', [BasicDataController::class, 'get']);
            Route::get('/getEach', [BasicDataController::class, 'getEach']);
            Route::post('/update', [BasicDataController::class, 'update']);
            Route::post('/delete', [BasicDataController::class, 'delete']);
        });

        Route::prefix("low_side_effect")->group(function () {
            Route::post('/store', [LowSideEffectController::class, 'store']);
            Route::get('/get', [LowSideEffectController::class, 'get']);
            Route::get('/getEach', [LowSideEffectController::class, 'getEach']);
            Route::post('/update', [LowSideEffectController::class, 'update']);
            Route::post('/delete', [LowSideEffectController::class, 'delete']);
        });

        Route::prefix("high_side_effect")->group(function () {
            Route::post('/store', [HighSideEffectController::class, 'store']);
            Route::get('/get', [HighSideEffectController::class, 'get']);
            Route::get('/getEach', [HighSideEffectController::class, 'getEach']);
            Route::post('/update', [HighSideEffectController::class, 'update']);
            Route::post('/delete', [HighSideEffectController::class, 'delete']);
        });

        Route::prefix("volunteer")->group(function () {
            Route::post('/store', [VolunteerController::class, 'store']);
            Route::get('/get', [VolunteerController::class, 'get']);
            Route::get('/getEach', [VolunteerController::class, 'getEach']);
            Route::post('/update', [VolunteerController::class, 'update']);
            Route::post('/delete', [VolunteerController::class, 'delete']);
            Route::get('/trash', [VolunteerController::class, 'trash']);
            Route::post('/recover', [VolunteerController::class, 'recover']);

            Route::prefix("trainings")->group(function () {
                Route::post('/store', [VolunteerTrainingController::class, 'store']);
                Route::post('/delete', [VolunteerTrainingController::class, 'delete']);
                Route::get('/get', [VolunteerTrainingController::class, 'get']);
            });
        });

        Route::prefix("patient")->group(function () {

            Route::get('/get', [PatientController::class, 'get']);
            Route::get('/getEach', [PatientController::class, 'getEach']);
            Route::post('/update', [PatientController::class, 'update']);
            Route::post('/delete', [PatientController::class, 'delete']);
            // Route::get('/export', [PatientController::class, 'export']);

            Route::prefix("mdrtb_regiment")->group(function () {
                Route::get('/get', [PatientMDRTBRegimentController::class, 'get']);
            });

            Route::prefix("pre_enroll")->group(function () {
                Route::prefix("support")->group(function () {
                    Route::get('/get', [PreEnrollSupportController::class, 'get']);
                    Route::get('/getEach', [PreEnrollSupportController::class, 'getEach']);
                });
            });

            Route::prefix("enroll")->group(function () {
                Route::prefix("support")->group(function () {
                    Route::get('/get', [EnrollSupportController::class, 'get']);
                    Route::get('/getEach', [EnrollSupportController::class, 'getEach']);
                });

                Route::prefix("information")->group(function () {
                    Route::post('/update', [EnrollSupportController::class, 'updateInformation']);
                });

                Route::prefix("finish_information")->group(function () {
                    Route::post('/update', [EnrollSupportController::class, 'updateFinishInformation']);
                });
            });
        });

        Route::prefix("family_member")->group(function () {
            Route::get('/get', [FamilyMemberController::class, 'get']);
            Route::get('/getEach', [FamilyMemberController::class, 'getEach']);
        });

        Route::prefix("activity")->group(function () {
            Route::prefix("he")->group(function () {
                Route::get('/get', [HeActivityController::class, 'get']);
                Route::get('/getEach', [HeActivityController::class, 'getEach']);
                Route::post('/store', [HeActivityController::class, 'store']);
                Route::post('/update', [HeActivityController::class, 'update']);
                Route::post('/delete', [HeActivityController::class, 'delete']);
                Route::post('/checked', [HeActivityController::class, 'checked']);
            });

            Route::prefix("home_visit")->group(function () {
                Route::get('/get', [HomeVisitActivityController::class, 'get']);
                Route::get('/getEach', [HomeVisitActivityController::class, 'getEach']);
                Route::post('/store', [HomeVisitActivityController::class, 'store']);
                Route::post('/update', [HomeVisitActivityController::class, 'update']);
                Route::post('/delete', [HomeVisitActivityController::class, 'delete']);
                Route::post('/checked', [HomeVisitActivityController::class, 'checked']);
            });

            Route::prefix("supervision_visit")->group(function () {
                Route::get('/get', [SupervisionVisitActivityController::class, 'get']);
                Route::get('/getEach', [SupervisionVisitActivityController::class, 'getEach']);
                Route::post('/store', [SupervisionVisitActivityController::class, 'store']);
                Route::post('/update', [SupervisionVisitActivityController::class, 'update']);
                Route::post('/delete', [SupervisionVisitActivityController::class, 'delete']);
                Route::post('/checked', [SupervisionVisitActivityController::class, 'checked']);
            });


            Route::prefix("counseling")->group(function () {
                Route::get('/get', [CounselingActivityController::class, 'get']);
                Route::get('/getEach', [CounselingActivityController::class, 'getEach']);
                Route::post('/store', [CounselingActivityController::class, 'store']);
                Route::post('/update', [CounselingActivityController::class, 'update']);
                Route::post('/delete', [CounselingActivityController::class, 'delete']);
                Route::post('/checked', [CounselingActivityController::class, 'checked']);
            });
        });

        Route::prefix("refer_patient")->group(function () {
            Route::post('/store', [ReferPatientController::class, 'store']);
            Route::get('/get', [ReferPatientController::class, 'get']);
            Route::get('/getEach', [ReferPatientController::class, 'getEach']);
            Route::post('/update', [ReferPatientController::class, 'update']);
            Route::post('/delete', [ReferPatientController::class, 'delete']);
            //Route::post('/savePresumptive', [ReferPatientController::class, 'savePresumptive']);
        });

        Route::prefix("presumptive")->group(function () {
            Route::get('/index_code', [PresumptiveController::class, 'searchByIndexCode']);
            Route::get('/get', [PresumptiveController::class, 'get']);
            Route::get('/getEach', [PresumptiveController::class, 'getEach']);
            Route::get('/refer/get', [PresumptiveController::class, 'getReferList']);
        });

        Route::prefix("dots_patient")->group(function () {
            Route::get('/get', [DOTSPatientController::class, 'get']);
            Route::get('/getEach', [DOTSPatientController::class, 'getEach']);

            Route::prefix("volunteer_activity")->group(function () {
                Route::get('/get', [DOTSVolunteerController::class, 'get']);
                Route::get('/getEach', [DOTSVolunteerController::class, 'getEach']);
            });

            Route::prefix("visit_report")->group(function () {
                Route::get('/get', [DOTSVisitReportController::class, 'get']);
            });
            Route::prefix("activity")->group(function () {
                Route::get('/get', [DOTSActivityController::class, 'get']);
                Route::get('/getEach', [DOTSActivityController::class, 'getEach']);
            });
        });

        Route::prefix("report")->group(function () {
            Route::prefix("form7")->group(function () {
                Route::get('/get', [ReportController::class, 'getForm7Report']);
                Route::get('/export', [ReportController::class, 'exporForm7Report']);
            });

            Route::prefix("monthly")->group(function () {
                Route::get('/get', [ReportController::class, 'getMonthlyReport']);
            });

            Route::prefix("volunteer")->group(function () {
                Route::get('/reported', [ReportController::class, 'getReportedVolunteer']);
                Route::get('/dots/reported', [ReportController::class, 'getDOTSReportedVolunteer']);
                Route::get('/detail', [ReportController::class, 'getVolunteerDetailReport']);
            });
            Route::prefix("nomination")->group(function () {
                Route::get('/get', [ReportController::class, 'getNominationList']);
            });
            
             Route::prefix("nomination14A")->group(function () {
                Route::get('/get', [ReportController::class, 'getNominationList14A']);
            });
           
        });



        Route::prefix("member")->group(function () {
            Route::get('/get', [MemberController::class, 'get']);
            Route::get('/getEach', [MemberController::class, 'getEach']);
            Route::post('/store', [MemberController::class, 'store']);
            Route::post('/update', [MemberController::class, 'update']);
            Route::post('/delete', [MemberController::class, 'delete']);
        });

        Route::prefix("data")->group(function () {
            Route::post('/import', [DataImportController::class, 'import']);
        });
        
         Route::prefix("innodot")->group(function () {
            Route::post('/import', [InnoDotController::class, 'import']);
        });
        
    });
    
});
