
<?php

use App\Http\Controllers\DA\LoginController;
use App\Http\Controllers\DA\VolunteerController;
use App\Http\Controllers\DA\VolunteerTrainingController;
use App\Http\Controllers\DA\PatientController;
use App\Http\Controllers\DA\PreEnrollSupportController;
use App\Http\Controllers\DA\EnrollSupportController;
use App\Http\Controllers\DA\TownshipController;
use App\Http\Controllers\DA\BasicDataController;
use App\Http\Controllers\DA\FamilyMemberController;
use App\Http\Controllers\DA\PresumptiveController;
use App\Http\Controllers\DA\PresumptiveDiagnosisController;
use App\Http\Controllers\DA\ReferPatientController;
use App\Http\Controllers\DA\OutsideTownshipController;
use App\Http\Controllers\DA\DelagatedPersonController;
use App\Http\Controllers\DA\PatientMDRTBRegimentController;
use App\Http\Controllers\DA\HeActivityController;
use App\Http\Controllers\DA\HomeVisitActivityController;
use App\Http\Controllers\DA\SupervisionVisitActivityController;
use App\Http\Controllers\DA\CounselingActivityController;
use App\Http\Controllers\DA\DOTSPatientController;
use App\Http\Controllers\DA\DOTSActivityController;
use App\Http\Controllers\DA\DOTSVolunteerController;
use App\Http\Controllers\DA\DOTSVisitReportController;
use App\Http\Controllers\DA\ReportController;


Route::prefix("da")->group(function () {
    //  Route::get('ci/get', [PresumptiveController::class, 'getCi']);
    //  Route::post('ci/delete', [PresumptiveController::class, 'deleteCi']);
    //  Route::get('ci/getEach', [PresumptiveController::class, 'getEachCi']);
      
    Route::get('/activity/he/export', [HeActivityController::class, 'export']);
    
    Route::post('/login', [LoginController::class, 'login']);

    Route::middleware('auth:das-api')->group(function () {
        Route::prefix("your")->group(function () {
            Route::get('/', [LoginController::class, 'getYour']);
            Route::post('/changePassword', [LoginController::class, 'changePassword']);
        });

        Route::prefix("report")->group(function () {
            Route::prefix("form7")->group(function () {
                Route::get('/get', [ReportController::class, 'getForm7Report']);
                Route::get('/export', [ReportController::class, 'exporForm7Report']);
            });

            Route::prefix("monthly")->group(function () {
                Route::get('/get', [ReportController::class, 'getMonthlyReport']);
            });

            Route::prefix("volunteer")->group(function () {
                Route::get('/reported', [ReportController::class, 'getReportedVolunteer']);
                Route::get('/dots/reported', [ReportController::class, 'getDOTSReportedVolunteer']);
                Route::get('/detail', [ReportController::class, 'getVolunteerDetailReport']);
            });
            Route::prefix("nomination")->group(function () {
                Route::get('/get', [ReportController::class, 'getNominationList']);
            });
        });
        
        Route::prefix("volunteer")->group(function () {

            Route::get('/get', [VolunteerController::class, 'get']);
            Route::get('/getEach', [VolunteerController::class, 'getEach']);
            
            Route::get('/get_volunteers_by_township', [VolunteerController::class, 'getVolunteersByTownship']);


            Route::prefix("trainings")->group(function () {
                Route::get('/get', [VolunteerTrainingController::class, 'get']);
            });
        });

        Route::prefix("township")->group(function () {

            Route::get('/get', [TownshipController::class, 'get']);
            Route::get('/get-all', [TownshipController::class, 'getAll']);
        });

        Route::prefix("outside_township")->group(function () {

            Route::get('/get', [OutsideTownshipController::class, 'get']);
        });

        Route::prefix("basic_data")->group(function () {
            Route::get('/get', [BasicDataController::class, 'get']);
        });

        Route::prefix("patient")->group(function () {
            Route::post('/store', [PatientController::class, 'store']);
            Route::get('/get', [PatientController::class, 'get']);
            Route::get('/getEach', [PatientController::class, 'getEach']);
            
            Route::get('/getByIndexCode', [PatientController::class, 'getByIndexCode']);
            
            Route::post('/update', [PatientController::class, 'update']);
            Route::post('/delete', [PatientController::class, 'delete']);
            Route::post('/export', [PatientController::class, 'export']);

            Route::prefix("pre_enroll")->group(function () {
                Route::prefix("support")->group(function () {
                    Route::post('/store', [PreEnrollSupportController::class, 'store']);
                    Route::get('/get', [PreEnrollSupportController::class, 'get']);
                    Route::get('/getEach', [PreEnrollSupportController::class, 'getEach']);
                    Route::post('/delete', [PreEnrollSupportController::class, 'delete']);
                });
            });

            Route::prefix("enroll")->group(function () {
                Route::prefix("support")->group(function () {
                    Route::post('/store', [EnrollSupportController::class, 'store']);
                    Route::post('/update', [EnrollSupportController::class, 'update']);
                    Route::get('/get', [EnrollSupportController::class, 'get']);
                    Route::get('/getEach', [EnrollSupportController::class, 'getEach']);
                    Route::get('/getOutsideTownship', [EnrollSupportController::class, 'getOutsideTownship']);
                    Route::post('/delete', [EnrollSupportController::class, 'delete']);
                });

                Route::prefix("information")->group(function () {
                    Route::post('/update', [EnrollSupportController::class, 'updateInformation']);
                });

                Route::prefix("finish_information")->group(function () {
                    Route::post('/update', [EnrollSupportController::class, 'updateFinishInformation']);
                });
            });

            Route::prefix("mdrtb_regiment")->group(function () {
                Route::post('/store', [PatientMDRTBRegimentController::class, 'store']);
                Route::post('/delete', [PatientMDRTBRegimentController::class, 'delete']);
                Route::get('/get', [PatientMDRTBRegimentController::class, 'get']);
            });
        });

        Route::prefix("presumptive")->group(function () {
            Route::post('/addNew', [PresumptiveController::class, 'addNew']);
            Route::get('/index_code', [PresumptiveController::class, 'searchByIndexCode']);
            Route::get('/previous_code', [PresumptiveController::class, 'searchByPreviousCode']);
            Route::get('/get', [PresumptiveController::class, 'get']);
            Route::get('/getSupportingTownshipPresumptive', [PresumptiveController::class, 'getSupportingTownshipPresumptive']);
            
            Route::get('/getEach', [PresumptiveController::class, 'getEach']);
            Route::post('/delete', [PresumptiveController::class, 'delete']);
            Route::post('/update', [PresumptiveController::class, 'update']);

            Route::prefix("diagnosis")->group(function () {
                Route::post('/store', [PresumptiveDiagnosisController::class, 'store']);
                Route::get('/index_code', [PresumptiveDiagnosisController::class, 'searchByIndexCode']);
                Route::get('/get', [PresumptiveDiagnosisController::class, 'get']);
                Route::get('/getEach', [PresumptiveDiagnosisController::class, 'getEach']);
                Route::post('/delete', [PresumptiveDiagnosisController::class, 'delete']);
                Route::post('/delete-each', [PresumptiveDiagnosisController::class, 'deleteEach']);
                Route::post('/edit', [PresumptiveDiagnosisController::class, 'update']);
            });
            
             Route::prefix("ci")->group(function () {
                Route::post('/store', [PresumptiveController::class, 'storeCi']);
                Route::get('/get', [PresumptiveController::class, 'getCi']);
                Route::get('/get', [PresumptiveController::class, 'getCi']);
                Route::get('/getEach', [PresumptiveController::class, 'getEachCi']);
                Route::post('/delete', [PresumptiveController::class, 'deleteCi']);
                Route::post('/update', [PresumptiveController::class, 'updateCi']);
                });
        });

        Route::prefix("family_member")->group(function () {
            Route::post('/store', [FamilyMemberController::class, 'store']);
            Route::get('/get', [FamilyMemberController::class, 'get']);
            Route::get('/getEach', [FamilyMemberController::class, 'getEach']);
            Route::post('/update', [FamilyMemberController::class, 'update']);
            Route::post('/delete', [FamilyMemberController::class, 'delete']);
            Route::post('/savePresumptive', [FamilyMemberController::class, 'savePresumptive']);
        });

        Route::prefix("refer_patient")->group(function () {
            Route::post('/store', [ReferPatientController::class, 'store']);
            Route::get('/get', [ReferPatientController::class, 'get']);
            Route::get('/getEach', [ReferPatientController::class, 'getEach']);
            Route::post('/update', [ReferPatientController::class, 'update']);
            Route::post('/delete', [ReferPatientController::class, 'delete']);
            Route::post('/savePresumptive', [ReferPatientController::class, 'savePresumptive']);
        });

        Route::prefix("delagated_person")->group(function () {
            Route::post('/store', [DelagatedPersonController::class, 'store']);
            Route::get('/get', [DelagatedPersonController::class, 'get']);
            Route::get('/getEach', [DelagatedPersonController::class, 'getEach']);
            Route::post('/update', [DelagatedPersonController::class, 'update']);
            Route::post('/delete', [DelagatedPersonController::class, 'delete']);
            //Route::post('/savePresumptive', [DelagatedPersonController::class, 'savePresumptive']);
        });

        Route::prefix("activity")->group(function () {
            Route::prefix("he")->group(function () {
                Route::get('/get', [HeActivityController::class, 'get']);
                Route::get('/getEach', [HeActivityController::class, 'getEach']);
                Route::post('/store', [HeActivityController::class, 'store']);
                Route::post('/update', [HeActivityController::class, 'update']);
                Route::post('/delete', [HeActivityController::class, 'delete']);
            });

            Route::prefix("home_visit")->group(function () {
                Route::get('/get', [HomeVisitActivityController::class, 'get']);
                Route::get('/getEach', [HomeVisitActivityController::class, 'getEach']);
                Route::post('/store', [HomeVisitActivityController::class, 'store']);
                Route::post('/update', [HomeVisitActivityController::class, 'update']);
                Route::post('/delete', [HomeVisitActivityController::class, 'delete']);
            });



            Route::prefix("supervision_visit")->group(function () {
                Route::get('/get', [SupervisionVisitActivityController::class, 'get']);
                Route::get('/getEach', [SupervisionVisitActivityController::class, 'getEach']);
                Route::post('/store', [SupervisionVisitActivityController::class, 'store']);
                Route::post('/update', [SupervisionVisitActivityController::class, 'update']);
                Route::post('/delete', [SupervisionVisitActivityController::class, 'delete']);
            });

            Route::prefix("counseling")->group(function () {
                Route::get('/get', [CounselingActivityController::class, 'get']);
                Route::get('/getEach', [CounselingActivityController::class, 'getEach']);
                Route::post('/store', [CounselingActivityController::class, 'store']);
                Route::post('/update', [CounselingActivityController::class, 'update']);
                Route::post('/delete', [CounselingActivityController::class, 'delete']);
            });
        });
        Route::prefix("dots_patient")->group(function () {
            Route::post('/store', [DOTSPatientController::class, 'store']);
            Route::post('/update', [DOTSPatientController::class, 'update']);
            Route::post('/delete', [DOTSPatientController::class, 'delete']);
            Route::get('/get', [DOTSPatientController::class, 'get']);
            Route::get('/getEach', [DOTSPatientController::class, 'getEach']);

            Route::prefix("volunteer_activity")->group(function () {
                Route::get('/get', [DOTSVolunteerController::class, 'get']);
                Route::get('/getEach', [DOTSVolunteerController::class, 'getEach']);
                Route::post('/update', [DOTSVolunteerController::class, 'update']);
                Route::post('/store', [DOTSVolunteerController::class, 'store']);
                Route::post('/delete', [DOTSVolunteerController::class, 'delete']);
            });

            Route::prefix("visit_report")->group(function () {
                Route::get('/get', [DOTSVisitReportController::class, 'get']);
                Route::post('/store', [DOTSVisitReportController::class, 'store']);
                Route::post('/delete', [DOTSVisitReportController::class, 'delete']);
            });

            Route::prefix("visit_date")->group(function () {
                Route::post('/finish', [DOTSPatientController::class, 'finishVisitDate']);
                Route::get('/get', [DOTSPatientController::class, 'getVisitDate']);
            });

            Route::prefix("activity")->group(function () {
                Route::get('/get', [DOTSActivityController::class, 'get']);
                Route::get('/getEach', [DOTSActivityController::class, 'getEach']);
                Route::post('/update', [DOTSActivityController::class, 'update']);
                Route::post('/store', [DOTSActivityController::class, 'store']);
                Route::post('/delete', [DOTSActivityController::class, 'delete']);
            });
            
    });
});
});
