<?php

use App\Http\Controllers\Clinic\LoginController;
use App\Http\Controllers\Clinic\PatientController;
use App\Http\Controllers\Clinic\TreatmentChangeController;
use App\Http\Controllers\Clinic\VisitController;
use App\Http\Controllers\Clinic\TreatmentController;
use App\Http\Controllers\Clinic\PostTreatmentController;



Route::prefix("clinic")->group(function () {
    Route::post('/login', [LoginController::class, 'login']);

    Route::middleware('auth:clinics-api')->group(function () {
        Route::prefix("your")->group(function () {
            Route::get('/', [LoginController::class, 'getYour']);
        });

        Route::prefix("patients")->group(function () {
            Route::post('/store', [PatientController::class, 'store']);
            Route::get('/getAll', [PatientController::class, 'getAll']);
            Route::get('/getEach', [PatientController::class, 'getEach']);
            Route::post('/delete', [PatientController::class, 'delete']);
            Route::post('/update', [PatientController::class, 'update']);

            Route::prefix("treatment_changes")->group(function () {
                Route::get('/get', [TreatmentChangeController::class, 'getAll']);
                Route::post('/store', [TreatmentChangeController::class, 'store']);
                Route::post('/update', [TreatmentChangeController::class, 'update']);
                Route::post('/delete', [TreatmentChangeController::class, 'delete']);
                Route::get('/getEach', [TreatmentChangeController::class, 'getEach']);
            });

            Route::prefix("visits")->group(function () {
                Route::get('/get', [VisitController::class, 'getAll']);
                Route::post('/store', [VisitController::class, 'store']);
                Route::post('/update', [VisitController::class, 'update']);
                Route::post('/delete', [VisitController::class, 'delete']);
                Route::get('/getEach', [VisitController::class, 'getEach']);
            });

            Route::prefix("treatments")->group(function () {
                Route::get('/get', [TreatmentController::class, 'getAll']);
                Route::post('/store', [TreatmentController::class, 'store']);
                Route::post('/update', [TreatmentController::class, 'update']);
                Route::post('/delete', [TreatmentController::class, 'delete']);
                Route::get('/getEach', [TreatmentController::class, 'getEach']);
            });


            Route::prefix("post_treatments")->group(function () {
                Route::get('/get', [PostTreatmentController::class, 'getAll']);
                Route::post('/store', [PostTreatmentController::class, 'store']);
                Route::post('/update', [PostTreatmentController::class, 'update']);
                Route::post('/delete', [PostTreatmentController::class, 'delete']);
                Route::get('/getEach', [PostTreatmentController::class, 'getEach']);
            });


        });
    });
});
