<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\CommentController;
use App\Http\Controllers\PImportController;
use App\Http\Controllers\PA\PresumptiveController;
use App\Http\Controllers\PA\PatientController;
use App\Http\Controllers\PA\SupervisionVisitActivityController;
use App\Http\Controllers\PA\CounselingActivityController;
use App\Http\Controllers\PA\HeActivityController;
// use App\Http\Controllers\PA\HomeVisitActivityController;
// use App\Http\Controllers\PA\SupervisionVisitActivityController;
use App\Http\Controllers\Dashboard\DOTSPatientController;

use Illuminate\Support\Facades\Mail;

use App\Mail\SendMail;
use Carbon\Carbon;

require __DIR__ . '/dashboard/routes.php';
require __DIR__ . '/pa/routes.php';
require __DIR__ . '/da/routes.php';
require __DIR__ . '/dots_app/routes.php';
require __DIR__ . '/enroll_app/routes.php';
require __DIR__ . '/vol_app/routes.php';
require __DIR__ . '/clinic/routes.php';
require __DIR__ . '/supervision/routes.php';

Route::get('/add_dots_visit',function () {
    
    $m=2;

    for($j=0;$j<=10;$j++)
    {
        $model =new \App\Models\DotsVisitDate();
        $model->status=1;
        $model->dots_patient_id=597;
        $model->date = Carbon::create(2024,$m,5)->addDays($j)->toDateString();
        $model->low_side_effect=0;
        $model->high_side_effect=1;
        $model->type=2;
        $model->duration=0;
        $model->volunteer_id=962;
        
        $model->save();
    }
    
    for($i=0;$i<=8;$i++)
    {
        $model =new \App\Models\DotsVisitDate();
        $model->status=1;
        $model->dots_patient_id=597;
        $model->date = Carbon::create(2024,$m,16)->addDays($i)->toDateString();
        $model->low_side_effect=0;
        $model->high_side_effect=1;
        $model->type=1;
        $model->duration=20;
        $model->volunteer_id=962;
        
        $model->save();
    }
        
        
        return $model;
   
});


Route::get('/testing/delete/',function () {
     $presumptive  = new \App\Models\Presumptive();
     $presumptives=$presumptive->where('township_id',99)
                        ->with([
                            "diagonsis" => function ($query) {
                                $query->with([
                                    "symptons","risk_factors","hiv_result_name"]);
                            }, "existing_presumptive_data",
                        ])
                        ->get();

  return $presumptives;
    
     foreach($presumptives as $p)
     {
         $p_id=$p->id;
         $diagnosis=new \App\Models\PresumptiveDiagnosis();
         $diagnosis=$diagnosis->where("presumptive_id",$p_id)->first();
         if($diagnosis)
         {
             $d_id=$diagnosis->id;
        
             $sy= DB::table('presumptive_diagnosis_sympton')->where('presumptive_diagnosis_id', $d_id)->delete();
             $rf= DB::table('presumptive_diagnosis_risk_factor')->where('presumptive_diagnosis_id', $d_id)->delete();
          
          
             $diagnosis->delete();
            
         }
        $p->delete();
     }
     return "success";                  
    
    
});

Route::get('/hashcode',function (Request $request) {
    
    $password =19465;
  
    $hashedPassword = bcrypt($password);
    return $hashedPassword;
});


Route::get('/patients/monywa/',function () {
    
    $patients = DB::select('SELECT patients.id,patients.name,mdrtb_reg_no,mdrtb_reg_year,sex,TIMESTAMPDIFF(YEAR, dob, CURDATE()) AS age,treatment_startdate,
                                CASE 
                                WHEN sex = 1 THEN "Male"
                                ELSE "Unknown" 
                                END AS sex
                                ,latest_regiments.regiment_date,latest_regiments.regiment_name
                            FROM patients
                             INNER JOIN (
                                SELECT patient_id, MAX(patient_mdrtb_regiments.id) AS latest_regiment_id,mdrtb_regiment_id,date	as regiment_date,mdrtb_regiments.name as regiment_name
                                FROM patient_mdrtb_regiments
                                JOIN mdrtb_regiments
                                ON mdrtb_regiments.id = patient_mdrtb_regiments.mdrtb_regiment_id
                                GROUP BY patient_id
                            ) AS latest_regiments 
                            ON latest_regiments.patient_id = patients.id
                            INNER JOIN patient_mdrtb_regiments
                            ON patient_mdrtb_regiments.id = latest_regiments.latest_regiment_id
                            WHERE patients.township_id = 28
                            AND patients.final_outcome is null'
                        );
   
    return $patients;           
    
    //  $patients  = new \App\Models\Patient();
    //  $patients=$patients->where('township_id',28)->select('id','mdrtb_reg_no','mdrtb_reg_year','township_id','finished_date','change_finished_date')
    //                     ->with('mdrtbRegiments')->get();
                  
});

Route::post("save-comments",[CommentController::class, 'store']);
Route::post("delete-comments",[CommentController::class, 'delete']);
Route::post("done-comments",[CommentController::class, 'done']);
Route::get("get-comments",[CommentController::class, 'get']);
Route::get("get-comments-count",[CommentController::class, 'getCount']);
Route::get("update-month",[CommentController::class, 'updateMonth']);

Route::get('/presumptive/export', [PresumptiveController::class, 'export']);
Route::get('/familymember/export', [PresumptiveController::class, 'familymember_export']);
Route::get('/ci/export', [App\Http\Controllers\DA\PresumptiveController::class, 'ci_export']);

Route::post('/testing/d/enroll/patient',function () {
    
        $township_id=11;
    
        $arrays = [
         
             [ 'code' => 9,
                'year' => 24,
                'monopoly'=>2,
            ],
            
             [ 'code' => 1,
                'year' => 24,
                'monopoly'=>2,
            ],
            
             [ 'code' => 2,
                'year' => 24,
                'monopoly'=>1,
            ],
             [ 'code' => 4,
                'year' => 23,
                'monopoly'=>1,
            ],
             [ 'code' => 5,
                'year' => 23,
                'monopoly'=>1,
            ],
             [ 'code' => 6,
                'year' => 23,
                'monopoly'=>1,
            ],
             [ 'code' => 7,
                'year' => 23,
                'monopoly'=>1,
            ],
             [ 'code' => 9,
                'year' => 23,
                'monopoly'=>1,
            ],
             [ 'code' => 10,
                'year' => 23,
                'monopoly'=>1,
            ],
             [ 'code' => 10,
                'year' => 24,
                'monopoly'=>1,
            ],
             [ 'code' => 11,
                'year' => 24,
                'monopoly'=>1,
            ],
             [ 'code' => 12,
                'year' => 24,
                'monopoly'=>1,
            ],
             [ 'code' => 3,
                'year' => 24,
                'monopoly'=>1,
            ],
             [ 'code' => 4,
                'year' => 24,
                'monopoly'=>1,
            ],
             [ 'code' => 5,
                'year' => 24,
                'monopoly'=>1,
            ],
             [ 'code' => 6,
                'year' => 24,
                'monopoly'=>1,
            ],
             [ 'code' => 7,
                'year' => 24,
                'monopoly'=>1,
            ],
             [ 'code' => 8,
                'year' => 24,
                'monopoly'=>1,
            ],
            ];
       
   // $code=request("code");
    // $year=request("year");
    // $monopoly=request("monopoly");
    // $township_id=request("township_id"); 
     
            // ->where('mdrtb_monopoly',$arr['monopoly'])
    $patient  = new \App\Models\Patient();
    
    $patientNames = [];
    
    foreach($arrays as $arr)
    {
          $patient=$patient->where('mdrtb_reg_no',$arr['code'])
            ->where('mdrtb_reg_year',$arr['year'])
            ->where('mdrtb_monopoly',$arr['monopoly'])
            ->where('township_id',$township_id)
            ->first();
            
         if ($patient) {
            $patientNames[] = $patient->name; // Assuming 'name' is the field for the patient's name
        }
         
           //return $patient;
            
           if($patient)
           {
                $model=new \App\Models\EnrollSupport;
                $model->patient_id=$patient->id;
                $model->nominated=2;
                $model->support=1;
                $model->support_month=7;
                $model->support_year=2024;
                $model->nominated_month=7;
                $model->nominated_year=2024;
                $model->save();
    
           }else{
                return response()->json(["success"=>false,"data"=>$arr]); 
           }
           
    }
       return response()->json(["success"=>true,
                                "data"=>$patientNames
       ]); 
   
});

Route::get('/side-effect/export', [App\Http\Controllers\Dashboard\HomeVisitActivityController::class, 'export']);
Route::get('/outcome-issue/export', [App\Http\Controllers\Dashboard\PatientController::class, 'exportIssue']);
Route::get('/outcome-finished/export', [App\Http\Controllers\Dashboard\PatientController::class, 'exportFinished']);

Route::get('/presumptive/power-bi', [PresumptiveController::class, 'getPowerBiData']);

Route::get('/patient/power-bi', [PatientController::class, 'getPowerBIData']);

Route::get('/supervision/power-bi', [SupervisionVisitActivityController::class, 'getPowerBi']);
Route::get('/counseling/power-bi', [CounselingActivityController::class, 'getPowerBi']);
Route::get('/he/power-bi', [HeActivityController::class, 'getPowerBi']);
Route::get('/home-visit/power-bi', [HomeVisitActivityController::class, 'getPowerBi']);

Route::get('/dots/patient/export', [DOTSPatientController::class, 'export']);
Route::get('/pa/dots/patient/export', [App\Http\Controllers\PA\DOTSPatientController::class, 'export']);

Route::get('/dashboard/testing/monthly', [DOTSPatientController::class, 'testing']);//testing

//Route::get('/activity/he/export', [HeActivityController::class, 'export']);
// Route::get('/activity/homevisit/export', [HomeVisitActivityController::class, 'export']);
// Route::get('/activity/supervisionvisit/export', [HomeVisitActivityController::class, 'export']);

Route::get('/dashboard/activity/he/export', [App\Http\Controllers\Dashboard\HeActivityController::class, 'export']);

Route::post('/check-vol-code',function(){
    $vol=\App\Models\Volunteer::where("code",request("code"))->first();
    if ($vol){
        return response()->json(["success"=>true]);
    }
    return response()->json(["success"=>false]);
});

Route::get('/volunteers',function(){
    $vol=\App\Models\Volunteer::where("status",1)->whereHas("township",function($query){
        $query->where("township_group_id",2);  
    })->with("township")->get();
    return response()->json(["data"=>$vol]);
    
});


Route::post("patient-import",function () {
    $data=request()->all();
    foreach ($data as $eachPatient){
       
        $township=\App\Models\Township::where("short_code",$eachPatient["Township"])->first();
        $year=date("Y")-$eachPatient["Age"];
        $counter=0;
        $dob=$year."-01-01";
        if ($township){
            $model=new \App\Models\Patient;
            $model->name=$eachPatient["Name"];
            $model->dob=$dob;
            $model->address="--";
            $model->sex=$eachPatient["Sex"]=="M"?1:2;
            $model->township_id=$township->id;
            $model->mdrtb_reg_no=$eachPatient["MDRTB Reg No."];
            $model->mdrtb_reg_year=$eachPatient["MDRTB Reg Year"];
            $model->pre_enroll=0;
            $model->save();
            $counter++;
        }
    }
    return $counter;
});

// Route::post("receive_volunteer_from_picts",function(){
//     $data=json_decode(request()->data);
//     $password = rand(10000, 99999);
//     try {
//             $township=\App\Models\Township::where("short_code",$data->township_code)->first();
//             $result=\App\Models\Volunteer::create([
//                     "name" => $data->name,
//                     "age" => $data->age,
//                     "gender" => $data->gender,
//                     "address" => '',
//                     "phone" => $data->phone,
//                     "education_status" => $data->education_status_id,
//                     "occupation" => $data->occupation_id,
//                     "remark" => $data->remark,
//                     "township_id" => $township->id,
//                     "password" => bcrypt($password),
//                     "plain_password" => $password,
//                     "serial" => $data->township_serial,
//                     "code" => $data->code,
//                      "global_id" => $data->id,
//             ]);
//             return response()->json(["success"=>true,"data"=>$result]);
//     }
//      catch (\Exception $e) {
//                 return response()->json(["msg"=>$e->getMessage()]);
//     }
     
    
// });


Route::get("sync-volunteers",function(){
    $volunteerService=new \App\Service\PA\Volunteer;
    $response = file_get_contents('http://150.95.26.210/api/volunteers-portal-raw?is_in_picts=1');
    $response = json_decode($response);
    try {
          DB::beginTransaction();    
          foreach ($response->data as $data){
              $password = rand(10000, 99999);
               $township=\App\Models\Township::where("short_code",$data->township_code)->first();
               $data->global_id=$data->id;
                $data->code=$data->code;
                if ($township){
                        \App\Models\Volunteer::create([
                    "name" => $data->name,
                    "age" => $data->age,
                    "gender" => $data->gender,
                    "address" => '',
                    "phone" => $data->phone,
                    "education_status" => $data->education_status_id,
                    "occupation" => $data->occupation_id,
                    "remark" => $data->remark,
                    "township_id" => $township->id,
                    "password" => bcrypt($password),
                    "plain_password" => $password,
                    "serial" => $data->township_serial,
                    "code" => $data->code,
                     "global_id" => $data->id,
            ]);
                }
              
          }
          DB::commit();
          return response()->json("success");
    }
    catch (\Exception $e) {
        DB::rollback();
        return response()->json(["msg"=>$e->getMessage()]);
    }
    return response()->json(true);
});


//change presumptive year 

// Route::post("change-presumptive-year",function () {
//     $model  = new \App\Models\PresumptiveDiagnosis();
    
//     $model = $model->with("presumptive",function($query){
//             $query->where("status",1);
//     });
//     $model=$model->whereBetween("register_date",['2023-01-01', '2023-12-31']);
//     $data=$this->getAll();
    
// });

Route::post("change-presumptive-year",function () {
        $model  = new \App\Models\PresumptiveDiagnosis;
        $data = $model->with(["presumptive" => function ($query) {
                $query->where('status',1)->get('unique_number');
            }])->whereBetween("register_date",['2022-01-01', '2022-12-31'])->get();
            
          foreach($data as $p){
              if(isset($p['presumptive']['unique_number']))
              {
                if (strpos($p['presumptive']['unique_number'],'2023')) {
                    
                    $originalString =$p['presumptive']['unique_number'];
                    $searchString = "2023";
                    $replacementString = "2022";
                    
                    $newString = Str::replaceFirst($searchString, $replacementString, $originalString);

                  $p['presumptive']->update(['unique_number' =>$newString]);
                }
              }
            }     
   return $data;
    
});

//presumptive import
Route::post("presumptive-import",function () {
    
      $datas = request()->all();
     $model = new \App\Models\Presumptive;
     foreach($datas as $data){
           
           $township=\App\Models\Township::where("short_code",$data["township"]["short_code"])->first();
         
             $insertedData = [];
        
            $insertedData = [
                'name' => $data["name"],
                'sex' =>  $data["sex"],
                'age' =>  $data["age"],
                'case_found_at' =>  $data["case_found_at"],
                'township_id' =>$township->id,
                'referral_from_id' => null,
            ];
            if ($insertedData["case_found_at"] == 3 || $insertedData["case_found_at"] == 5) {
                if($data["index_case_no"] == 'null'){
                    $insertedData["index_case_no"] = null;
                }else{
                    
                    if (strlen($data["index_case_no"])>2){
                    $year= $data["index_case_no"][0].$data["index_case_no"][1];
                    $code=  (int)substr($data["index_case_no"],3);
                    
                 
                    $insertedData["index_case_no"] = $code;
                    $insertedData["index_case_year"] =$year;
                    
                    $patient=\App\Models\Patient::where("mdrtb_reg_no",$code)->where("mdrtb_reg_year",$year)->where("township_id",$township->id)->first();
                    if ($patient){
                        
                         $insertedData["patient_id"]=$patient->id;
                    }
                    
                    }
               
                }
              
               
                $insertedData["relationship"] = $data["relationship"];
            }
        

        $insertedData["confirm"] = 1;
        $insertedData["unique_number"] = $data["unique_number"];


        $result = null;
        $result = $model->create($insertedData);

        
         foreach($data["patient_diagnosis"] as $index => $pData){
            saveDiagnosis($result->id, $pData);
          }
        
     }
     return $result;
    
});

    function saveDiagnosis($patientID, $data)
    {
        $model = new \App\Models\PresumptiveDiagnosis;
        if (isset($data["refer_id"])) {
            $model->refer_id = $patientID;
            $model->presumptive_id = $data["presumptive_id"];
            // $model->times = $this->presumptiveDiagnosis->getLastTime($data["presumptive_id"]);
            $model->times = intval($data["times"]);
        } else {
            $model->presumptive_id = $patientID;
            $model->times = intval($data["times"]);
        }


        $model->hiv_status = $data["hiv_status"];

        if ($data["hiv_status"] == 2) {
            $model->hiv_status=3;
            $model->hiv_date = $data["hiv_date"];
            $model->hiv_result = $data["hiv_result"];
            $model->hiv_code = $data["hiv_code"];
        }

        $model->sputum_status = $data["sputum_status"];

        if ($data["sputum_status"] == 2) {
                $model->sputum_status = 3;
            $model->sputum_date = $data["sputum_date"];
            $model->sputum_result = $data["sputum_result"];
        }


        $model->cxr_status = $data["cxr_status"];

        if ($data["cxr_status"] == 2) {
            $model->cxr_status = 3;
            $model->cxr_date = $data["cxr_date"];
            $model->cxr_result = $data["cxr_result"];
        }



        $model->gene_xpert_status = $data["gene_xpert_status"];

        if ($data["gene_xpert_status"] == 2) {
              $model->gene_xpert_status =3;

            $model->gene_xpert_date = $data["gene_xpert_date"];
            $model->gene_xpert_result = $data["gene_xpert_result"];
        }

        $model->culture_status = $data["culture_status"];

        if ($data["culture_status"] == 2) {
            $model->culture_status =3;
            $model->culture_date = $data["culture_date"];
            $model->culture_result = $data["culture_result"];
        }



        $model->dst_status = $data["dst_status"];

        if ($data["dst_status"] == 2) {
              $model->dst_status =3;
            $model->dst_date = $data["dst_date"];
            $model->dst_result = $data["dst_result"];
        }

        $model->other_investigation_status = $data["other_investigation_status"];

        if ($data["other_investigation_status"] == 2) {
             $model->other_investigation_status =3;
            $model->other_investigation_date = $data["other_investigation_date"];
            $model->other_investigation_test = $data["other_investigation_test"];
            $model->other_investigation_result = $data["other_investigation_result"];
        }

        $model->conclusion = $data["conclusion"];
        $model->conclusion_code = $data["conclusion_code"];
        $model->other_comment = $data["other_comment"];
        

         $model->register_date = $data["register_date"];
        

        $model->referral_type_id = $data["referral_type_id"];



        $model->referral_from_id = $data["referral_from_id"];

        $model->save();
        
        $symptons = [];
        foreach($data["symptons"] as $s){
            $model->symptons()->attach($s["id"]);
        }
        
        $riskFactors = [];
         foreach($data["risk_factors"] as $r){
            $model->risk_factors()->attach($r["id"]);
        }
        

        // $model->symptons()->attach($data["symptons"]);
        // $model->risk_factors()->attach($data["risk_factors"]);
    }




// Route::get('/saveAllTownships', function () {
//     $townships = \App\Models\Township::where("status",1)->get();
//     foreach ($townships as $twp) {
//         if ($twp->township_group_id == 1 || $twp->township_group_id == 2) {
//             $newTwpModel = new \App\Models\AllTownship;
//             $newTwpModel->name = $twp->name;s
//             $newTwpModel->short_code = $twp->short_code;
//             $newTwpModel->township_group_id = $twp->township_group_id;
//             $newTwpModel->region_id = $twp->region_id;
//             if ($twp->both_mdr_picts == 2) {
//                 $newTwpModel->project = 3;
//             } else {
//                 $newTwpModel->project = 2;
//             }

//             $newTwpModel->save();

//     }
// });


//volunteer import

// Route::post("/import", function () {
//     $data = request()->all();
//     $model = new \App\Models\Volunteer;
//     $trainingModel = new \App\Models\VolunteerTraining;
//     foreach ($data as $d) {
//         $township = \App\Models\Township::where("short_code", $d["township"]["short_code"])->first();
//         $code = null;


//         if ($d["serial"] < 10) $code = "0000";
//         else if ($d["serial"] < 100) $code = "000";
//         else if ($d["serial"] < 1000) $code = "00";
//         else if ($d["serial"] < 10000) $code = "0";


//         $code .= $d["serial"];




//         if ($township) {
//             $initial = $township->short_code;

//             $d["code"] = $initial . $code;
//             try {
//                 $model->create([
//                     "id" => $d["id"],
//                     "name" => $d["name"],
//                     "age" => $d["age"],
//                     "gender" => $d["gender"],
//                     "address" => $d["address"],
//                     "phone" => $d["phone"],
//                     "education_status" => $d["education_status"],
//                     "occupation" => $d["occupation"],
//                     "remark" => $d["remark"],
//                     "township_id" => $township->id,
//                     "password" => bcrypt($d["plain_password"]),
//                     "plain_password" => $d["plain_password"],
//                     "serial" => $d["serial"],
//                     "code" => $d["code"],
//                     "both_mdr_picts" => 1,
//                 ]);

//                 foreach ($d["volunteer_trainings"] as $vTraining) {
//                     $trainingModel->create([
//                         "date" => $vTraining["date"],
//                         "training_type_id" => $vTraining["training_type_id"],
//                         "type" => 1,
//                         "volunteer_id" => $vTraining["volunteer_id"],
//                     ]);
//                 }
//             } catch (Exception $e) {
//                 return $e->getMessage();
//             }
//         }
//     }
//     return $data[0];
// });


Route::get("runfamily",function(){
    $patients=\App\Models\Patient::all();
    foreach ($patients as $patient){
        $presumptive=\App\Models\Presumptive::where("patient_id",$patient->id)->first();
        if ( $presumptive){
              $presumptive->township_id=$patient->township_id;
        $presumptive->update();
        }
      
    }
    return $patients;
});

Route::post("/import", function () {
    $patients = \App\Models\Patient::where("mdrtb_reg_year", ">", 99)->get();
    foreach ($patients as $p) {
        $yearcode = (string)$p->mdrtb_reg_year;
        $year = $yearcode[2] . $yearcode[3];
        $p->mdrtb_reg_year = $year;
        $p->update();
    }

    // $model = new \App\Models\PA;
    // $data = request()->all();
    // foreach ($data as $each) {
    //     $township = \App\Models\Township::where("short_code", $each["township"]["short_code"])->first();
    //     if ($township) {
    //         $model->create([
    //             "name" => $each["name"],
    //             "township_id" => $township->id,
    //             "code" => $each["code"],
    //             "password" => $each["password"]
    //         ]);
    //     }
    // }
});

Route::get("/remove-dots-du",function(){
    $patients=\App\Models\Patient::where("status",1)->has('dots_patient', '>', 1)->with(["dots_patient"=>function($query){
        $query->orderBy("id","desc");
    }])->get();
    
    foreach ($patients as $p){
       
        foreach ($p->dots_patient as $index=>$d){
            if ($index==0){
                $d->status=1;
                $d->update();
            }
            else {
                $d->status=0;
                $d->update();
            }
        }
    }
    
    return $patients;
});


// Route::post("/import", function () {
//     $data = request()->all();
//     $patientModel = new \App\Models\Patient;
//     $dotsPatientModel = new \App\Models\DOTSPatient;
//     $regModel = new \App\Models\PatientMdrtbRegiment;
//     $dotsActivityModel = new \App\Models\DotsMainActivity;

//     DB::beginTransaction();

//     try {
//         foreach ($data as $d) {
//             $township = \App\Models\Township::where("short_code", $d["township"]["short_code"])->first();
//             $bornYear = 2022 - $d["age"];
//             $tbCode = $d["tb_code"];
//             $codeInital = "";
//             if ($tbCode[0] == "M") {
//                 $codeInital = "M";
//                 if ($tbCode[1] == "0") {
//                     $tbCode = $tbCode[2];
//                 } else {
//                     $tbCode = $tbCode[1] . $tbCode[2];
//                 }
//             } else if (strlen($tbCode) > 2) {
//                 $tbCode = $tbCode[0] . $tbCode[1];
//             }



//             $inserted = $patientModel->create([
//                 "name" => $d["name"],
//                 "sex" => $d["gender"],
//                 "dob" => $bornYear . "-01-01", // calcluldate by age
//                 "address" => $d["address"],
//                 "township_id" => $township->id,
//                 'type_of_tb' => $d["tb_type_id"],
//                 'treatment_startdate' => $d["treatment_startdate"],
//                 'mdrtb_reg_no' => $tbCode,
//                 'mdrtb_reg_year' => $d["tb_code_year"],
//                 'mdrtb_reg_initial' => $codeInital,
//                 "pre_enroll" => 0,
//                 "imported" => 1,
//             ]);
//             $regModel->create([
//                 'patient_id' => $inserted->id,
//                 'mdrtb_regiment_id' => $d["treatment_reg_id"],
//                 'date' => $d["treatment_startdate"],
//             ]);

//             $insertedDOTS = $dotsPatientModel->create([
//                 'patient_id' => $inserted->id,
//                 'volunteer_id' => $d['volunteer_id'],
//                 'phone' => $d['phone'],
//                 'body_weight' => $d['weight'],
//                 'dots_startdate' => $d['dots_startdate'],
//                 'dots_app_status' => 1,
//             ]);

//             $dotsActivityModel->create([
//                 "dots_patient_id" => $insertedDOTS->id,
//                 "dots_startdate" => $d["dots_startdate"],
//                 'volunteer_id' => $d['volunteer_id'],
//                 'dots_app_status' => 1,
//             ]);

//             foreach ($d["visit_dates"] as $visitData) {
//                 $model = new \App\Models\DOTSVisitDate;
//                 $model->date = $visitData["date"];
//                 $model->status = $visitData["status"];
//                 $model->dots_patient_id = $insertedDOTS->id;
//                 $model->low_side_effect = $visitData["low_side_effect"];
//                 $model->high_side_effect = $visitData["high_side_effect"];
//                 $model->duration = $visitData["duration"];
//                 $model->signature = $visitData["signature"];
//                 $model->type = $visitData["type"];
//                 $model->volunteer_id = $d['volunteer_id'];
//                 $model->save();
//             }
//         }
//         DB::commit();
//     } catch (\Exception $e) {
//         DB::rollback();
//         return $e->getMessage();
//     }



//     return count($data);
// });
