<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Document</title>
</head>
<body>
        <table>
            <thead>
                <tr>
                    <th>No</th>
                    <th>Code</th>
                    <th>Year</th>
                    <th>Name</th>
                    <th>Age</th>
                     <th>Sex</th>
                    <th>Township Group</th>
                    <th>Township</th>
                    <th>Regimen</th>
                    <th>Treatment Start Date</th>
                    <th>Date</th>
                   
                    
                    <th>Headache</th>
                    <th>Dizziness</th>
                    <th>Anxiety</th>
                    <th>Depression</th>
                    <th>Optic Neuritis</th>
                    <th>Tinnitus/Vertigo</th>
                    <th>Nausea/Vomiting</th>
                    <th>Gastro-intestinal tract upset</th>
                    <th>Change in bowel habit</th>
                    <th>Arrythmia</th>
                    <th>Hepatitis</th>
                    <th>Renal Impairment</th>
                    <th>Arthralgia/Arthritis</th>
                    <th>Peripheral neuropathy</th>
                    <th>Hypokalemia</th>
                    <th>Hypothyroidism(Goiter)</th>
                    <th>Drug allergy</th>
                    <th>Change in skin colour</th>
                    <th>Coagulopathy(derangement of hemostasis)</th>
                    <th>Are the previous symptoms getting worse?</th>
                    <th>Are you still suffering any fever, cough and profuse sweating at night?</th>
                    <th>Are you still dyspneic?</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($side_effects as $index=>$side_effect)
                    <tr>
                        <td>{{ $index+1 }}</td>
                        <td>{{ $side_effect->mdrtb_code}}</td>
                        <td>{{ $side_effect->mdrtb_year}}</td>
                        <td>{{ $side_effect->patient?$side_effect->patient->name : "" }}</td>
                         <td>{{$side_effect->patient?\Carbon\Carbon::parse($side_effect->patient->dob)->diff(\Carbon\Carbon::now())->format('%y')+1:""}}</td>
                         <td>
                            @if( $side_effect->patient)
                             {{ $side_effect->patient->sex==1? 'Male' : 'Female' }}
                             @else
                               ""
                             @endif
                        </td>
                        <td>{{ $side_effect->township->township_group->name}}</td>
                        <td>{{ $side_effect->township->name}}</td>
                        <td>{{ $side_effect->current_regimen}}</td>
                       <td>{{$side_effect->treatment_start_date}}</td>
                         
                        <td>{{ $side_effect->date}}</td>
                       
                       @foreach($side_effect->se_checklist as $index => $checklistItem)
                        @php
                            $field = 'question_no_' . ($loop->index + 1);
                        @endphp
            
                        @if(isset($checklistItem->$field))
                            <td>{{ $checklistItem->$field->val==2? 'Yes':'No' }}</td>
                        @endif
                    @endforeach
                       
                    </tr>
                @endforeach
            </tbody>
            
        </table>
</body>
</html>