<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Document</title>
</head>
<body>
        <table>
            <thead>
                <tr>
                    <th>No</th>
                    <th>Code</th>
                    <th>Name</th>
                    <th>Township</th>
                    <th>Township Code</th>
                    <th>Presumptive Township</th>
                    <th>Township Group</th>
                     <th>Outside Township</th>
                    <th>Age</th>
                    <th>Sex</th>
                    <th>Case Found At</th>
                    <th>Index Case</th>
                    <th>Index Case Year</th>
                    <th>Mono-Poly/SG</th>
                    <th>Relationship</th>
                    <th>Previous ID</th>
                    <th>Visit</th>
                    <th>Register Date</th>
                    <th>Register Month</th>
                    <th>Register Year</th>
                    <th>Refer From</th>
                    <th>Refer Type</th>
                    <th>Symptons</th>
                    <th>Risk Factors</th>
                    <th>Hiv Status</th>
                    <th>Hiv Date</th>
                    <th>Hiv Result</th>
                    <th>Hiv Code</th>
                    <th>Sputum</th>
                    <th>Sputum Date</th>
                    <th>Sputum Result</th>
                    <th>CXR</th>
                    <th>CXR Date</th>
                    <th>CXR Result</th>
                    <th>GeneXpert</th>
                    <th>GeneXpert Date</th>
                    <th>GeneXpert Result</th>
                    <th>Culture</th>
                    <th>Culture Date</th>
                    <th>Culture Result</th>
                    <th>DST</th>
                    <th>DST Date</th>
                    <th>DST Result</th>
                    <th>Other Investigation</th>
                    <th>Other Investigation Date</th>
                    <th>Other Investigation Test</th>
                    <th>Other Investigation Result</th>
                    <th>Conclusion</th>
                    <th>Code</th>
                    <th>Other Comment</th>
                    
                    
                </tr>
            </thead>
            <tbody>
                @foreach ($presumptives as $index=>$presumptive)
                <tr>
                        <td>{{ $index+1 }}</td>
                        <td>{{ $presumptive->presumptive->unique_number }}</td>
                        <td>{{ $presumptive->presumptive->name }}</td>
                        <td>{{ $presumptive->presumptive->township->name }}</td>
                         <td>{{ $presumptive->presumptive->township->short_code }}</td>
                        <td>
                            @if($presumptive->presumptive->supporting_township!=null)
                            {{ $presumptive->presumptive->supportingTownship->name }}
                            @else
                                
                            @endif
                        </td>
                         <td>
                              @if ($presumptive->presumptive->township->township_group_id ==1)
                                    MDR 1
                             @elseif ($presumptive->presumptive->township->township_group_id ==2)
                                    MDR 2
                             @else
                                ' '
                             @endif
                         </td>
                          <td>
                              @if($presumptive->presumptive->patient)
                                 <?php 
                                $outside_tsp=$presumptive->presumptive->patient->outside_tsp
                                ?>
                                @if($outside_tsp==2)
                                    Yes
                                @else
                                    No
                                @endif
                            @else
                                
                            @endif
                        </td>
                        <td>{{ $presumptive->presumptive->age }}</td>
                        <td>{{ $presumptive->presumptive->sex }}</td>
                        <td>
                            @if ($presumptive->presumptive->case_found_at==1)
                                HE
                            @elseif ($presumptive->presumptive->case_found_at==2)
                                TBCT
                            @elseif ($presumptive->presumptive->case_found_at==3)
                                DRTB CT
                            @elseif ($presumptive->presumptive->case_found_at==4)
                                Community
                            @elseif ($presumptive->presumptive->case_found_at==5)
                                Follow Up
                            @elseif ($presumptive->presumptive->case_found_at==6)
                                Missing
                            @endif

                        </td>
                        <td>
                            @if ($presumptive->presumptive->case_found_at==2 || $presumptive->presumptive->case_found_at==3 )
                                 {{ $presumptive->presumptive->index_case_no }} 
                            @endif   
                            
                        </td>
                         <td>
                            @if ($presumptive->presumptive->case_found_at==2 || $presumptive->presumptive->case_found_at==3 )
                                 {{ $presumptive->presumptive->index_case_year }} 
                            @endif   
                            
                        </td>
                        <td>
                            @if ($presumptive->presumptive->case_found_at==2 || $presumptive->presumptive->case_found_at==3 )
                            
                              <?php 
                                $monopoly=$presumptive->presumptive->index_case_monopoly
                                ?>
                                    @if($monopoly==1)
                                        No
                                    @elseif($monopoly==2)
                                        Yes
                                    @elseif($monopoly==3)
                                        SG
                                    @else
                                    @endif
                                        
                            @endif   
                            
                        </td>
                        <td>
                            @if ($presumptive->presumptive->case_found_at==2 || $presumptive->presumptive->case_found_at==3 )
                                        @if ($presumptive->presumptive->relationship==1)
                                                Household Member
                                        @elseif ($presumptive->presumptive->relationship==3)
                                                Close Contact
                                        @elseif ($presumptive->presumptive->relationship==4)
                                                Other Contact
                                        @else 
                                                Non-household Member
                                        @endif

                            @endif
                        </td>
                        <td>
                            @if ($presumptive->presumptive->case_found_at==5)
                                 {{ $presumptive->presumptive->previousID }} 
                            @endif
                        </td>
                        
                        
                            <td>
                                @if ($presumptive->times==1)
                                    First
                                @elseif ($presumptive->times==2)
                                    Second
                                @elseif ($presumptive->times==3)
                                    Third
                                @elseif ($presumptive->times==4)
                                    Fourth
                                @endif
                                Time
                            </td>
                            <td>
                                 @if ($presumptive->register_date)
                                    {{ \PhpOffice\PhpSpreadsheet\Shared\Date::dateTimeToExcel(\Carbon\Carbon::parse($presumptive->register_date))  }}
                                @endif
                            </td>
                            <td>
                                 @if ($presumptive->register_date)
                                    {{ \Carbon\Carbon::parse($presumptive->register_date)->format('M') }}
                                @endif
                            </td>
                             <td>
                                 @if ($presumptive->register_date)
                                    {{ \Carbon\Carbon::parse($presumptive->register_date)->format('Y') }}
                                @endif
                            </td>
                            <td>
                                @if ($presumptive->refer_from_name)
                                {{ $presumptive->refer_from_name->name }}
                                @endif
                            </td>
                            <td>
                                @if ($presumptive->refer_type_name)
                                {{ $presumptive->refer_type_name->name }}
                                @endif
                            </td>

                            <!-- sympton -->
                            <td>
                            @foreach ($presumptive->symptons as $sympton)
                                {{ $sympton->name }}
                            @endforeach
                            </td>
                            <!-- sympton -->

                             <!-- risk_factor -->
                             <td>
                            @foreach ($presumptive->risk_factors as $risk_factor)
                                {{ $risk_factor->name }}
                            @endforeach
                            </td>
                            <!-- risk_factor -->


                            

                            <!-- hiv -->
                            @if ($presumptive->hiv_status)
                            <td>
                                @if ($presumptive->hiv_status==0)
                                    Missing
                                @elseif ($presumptive->hiv_status==1)
                                    Not Done
                                @elseif ($presumptive->hiv_status==2)
                                    Done
                                @endif
                            </td>
                            <td>@if($presumptive->hiv_status==2) {{ \PhpOffice\PhpSpreadsheet\Shared\Date::dateTimeToExcel(\Carbon\Carbon::parse($presumptive->hiv_date))  }}  @endif</td>
                            <td>@if($presumptive->hiv_result_name) {{  $presumptive->hiv_result_name->name }} @endif </td>
                            <td>@if($presumptive->hiv_status==2) {{ $presumptive->hiv_code }} @endif</td>
                            @else 
                            <td>Missing</td>
                            <td></td>
                            <td></td>
                            <td></td>
                            @endif
                            <!-- hiv -->

                             <!-- sputum -->
                             @if ($presumptive->sputum_status)
                             <td>
                                 @if ($presumptive->sputum_status==0)
                                     Missing
                                 @elseif ($presumptive->sputum_status==1)
                                     Not Done
                                 @elseif ($presumptive->sputum_status==2)
                                     Done
                                 @endif
                             </td>
                             <td>{{ $presumptive->sputum_date  }}</td>
                             <td>@if($presumptive->sputum_result_name) {{  $presumptive->sputum_result_name->name }} @endif </td>
                             
                             @else 
                             <td>Missing</td>
                             <td></td>
                             <td></td>
                             
                             @endif
                             <!-- sputum -->


                             <!-- cxr -->
                                @if ($presumptive->cxr_status)
                                <td>
                                    @if ($presumptive->cxr_status==0)
                                        Missing
                                    @elseif ($presumptive->cxr_status==1)
                                        Not Done
                                    @elseif ($presumptive->cxr_status==2)
                                        Done
                                    @endif
                                </td>
                                <td>
                                    @if ($presumptive->cxr_date)
                                        {{ $presumptive->cxr_date  }}
                                    @endif
                                </td>
                                <td>@if($presumptive->cxr_result_name) {{  $presumptive->cxr_result_name->name }} @endif </td>
                                
                                @else 
                                <td>Missing</td>
                                <td></td>
                                <td></td>
                                
                                @endif
                             
                             <!-- cxr -->

                             <!-- gene_xpert -->
                             @if ($presumptive->gene_xpert_status)
                             <td>
                                 @if ($presumptive->gene_xpert_status==0)
                                     Missing
                                 @elseif ($presumptive->gene_xpert_status==1)
                                     Not Done
                                 @elseif ($presumptive->gene_xpert_status==2)
                                     Done
                                 @endif
                             </td>
                             <td>
                                @if ($presumptive->gene_xpert_date)
                                    {{ $presumptive->gene_xpert_date  }}
                                @endif
                            </td>
                             <td>@if($presumptive->gene_xpert_result_name) {{  $presumptive->gene_xpert_result_name->name }} @endif </td>
                             
                             @else 
                             <td>Missing</td>
                             <td></td>
                             <td></td>
                             
                             @endif
                          
                          <!-- gene_xpert -->

                          <!-- culture -->
                          @if ($presumptive->culture_status)
                          <td>
                              @if ($presumptive->culture_status==0)
                                  Missing
                              @elseif ($presumptive->culture_status==1)
                                  Not Done
                              @elseif ($presumptive->culture_status==2)
                                  Done
                              @endif
                          </td>
                          <td>
                            @if($presumptive->culture_date) 
                                {{ \PhpOffice\PhpSpreadsheet\Shared\Date::dateTimeToExcel(\Carbon\Carbon::parse($presumptive->culture_date))  }}
                            @endif
                        </td>
                          <td>@if($presumptive->culture_result_name) {{  $presumptive->culture_result_name->name }} @endif </td>
                          
                          @else 
                          <td>Missing</td>
                          <td></td>
                          <td></td>
                          
                          @endif
                       
                       <!-- culture -->

                        <!-- dst -->
                        @if ($presumptive->dst_status)
                        <td>
                            @if ($presumptive->dst_status==0)
                                Missing
                            @elseif ($presumptive->dst_status==1)
                                Not Done
                            @elseif ($presumptive->dst_status==2)
                                Done
                            @endif
                        </td>
                        <td>
                            @if($presumptive->dst_date)
                                {{ \PhpOffice\PhpSpreadsheet\Shared\Date::dateTimeToExcel(\Carbon\Carbon::parse($presumptive->dst_date))  }}
                            @endif
                        </td>
                        <td>@if($presumptive->dst_result_name) {{  $presumptive->dst_result_name->name }} @endif </td>
                        
                        @else 
                        <td>Missing</td>
                        <td></td>
                        <td></td>
                        
                        @endif
                     
                     <!-- dst -->

                     <!-- dst -->
                     @if ($presumptive->other_investigation_status)
                     <td>
                         @if ($presumptive->other_investigation_status==0)
                             Missing
                         @elseif ($presumptive->other_investigation_status==1)
                             Not Done
                         @elseif ($presumptive->other_investigation_status==2)
                             Done
                         @endif
                     </td>
                     <td>
                        @if ($presumptive->other_investigation_date)
                            {{ \PhpOffice\PhpSpreadsheet\Shared\Date::dateTimeToExcel(\Carbon\Carbon::parse($presumptive->other_investigation_date))  }}
                        @endif
                    </td>
                     <td>
                         @if ($presumptive->other_investigation_test=="" || $presumptive->other_investigation_test=="null")
                         @else 
                            {{$presumptive->other_investigation_test}}
                         @endif
                         
                    </td>
                     <td>
                         @if ($presumptive->other_investigation_result=="" || $presumptive->other_investigation_result=="null")
                         @else
                            {{  $presumptive->other_investigation_result }}
                         @endif
                         
                    </td>
                     
                     
                     @else 
                     <td>Missing</td>
                     <td></td>
                     <td></td>
                     <td></td>
                     @endif
                  
                  <!-- dst -->

                  <!-- conclusion -->
                        <td>{{ $presumptive->conclusion_name->name }}</td>
                        <td>{{ $presumptive->conclusion_code }}</td>
                        <td>{{ $presumptive->other_comment }}</td>
                        
                  <!-- conclusion -->

                        
                </tr>
                @endforeach
            </tbody>
            
        </table>
</body>
</html>