<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Document</title>
</head>
<body>
        <table>
            <thead>
                <tr>
                    <th>No</th>
                    <th>Name</th>
                    <th>Code</th>
                    <th>DOB</th>
                    <th>Age</th>
                    <th>Sex</th>
                    <th>Address</th>
                    <th>Township</th>
                    <th>Type Of Patient</th>
                    <th>Type Of TB</th>
                    <th>Treatment Start Date</th>
                    <th>Treatment Finished Date</th>
                  </tr>
            </thead>
            <tbody>
                @foreach ($patients as $index=>$patient)
                <tr>
                    <td>{{$index+1}}</td>
                    <td>{{$patient->name}}</td>
                    <td>{{$patient->reg_unique_code}}</td>
                    <td>{{$patient->dob}}</td>
                    <td>{{\Carbon\Carbon::parse($patient->dob)->diff(\Carbon\Carbon::now())->format('%y')+1}}</td>
                    <td>
                        @if( $patient->sex==1)
                           Male
                         @else
                           Female
                         @endif
                    </td>
                    <td>{{$patient->address}}</td>
                    <td>{{$patient->township->name}}</td>
                     <td>
                        @if($patient->type_of_patient==1)
                        New
                        @elseif($patient->type_of_patient==2)
                        Non-converter
                        @elseif($patient->type_of_patient==3)
                        Rx after LTF
                        @elseif($patient->type_of_patient==4)
                        Rx after failure
                        @elseif($patient->type_of_patient==5)
                        Relapse
                        @else
                        
                        @endif
                    </td>
                    <td>
                        @if($patient->type_of_tb==1)
                        Pulmonary
                        @elseif($patient->type_of_tb==2)
                        Extra Pulmonary
                        @elseif($patient->type_of_tb==3)
                        P+EP
                        @else
                        
                        @endif
                    </td>
                    <td>{{$patient->treatment_startdate}}</td>
                     <td>{{$patient->finished_date}}</td>
                </tr>
                @endforeach
                
            </tbody>
            
        </table>
</body>
</html>