<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Document</title>
</head>
<body>
        <table>
            <thead>
                <tr>
                    <th>No</th>
                    <th>Code</th>
                    <th>Year</th>
                    <th>Mono-Poly/SG</th>
                    <th>Outside Township</th>
                    <th>Name</th>
                    <th>Township</th>
                    <th>Township Code</th>
                    <th>Township Group</th>
                    <th>Household Member Name</th>
                    <th>Age</th>
                    <th>Sex</th>
                    <th>Symptom Screening</th>
                    <th>Diagonsis</th>
                    <th>Diagonsis Register Date</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($familymembers as $index=>$familymember)
                
                <tr>
                        <td>{{ $index+1 }}</td>
                        @if($familymember->patient)
                       <td>{{ $familymember->patient->mdrtb_reg_no ==null ? '':$familymember->patient->mdrtb_reg_no }}</td>
                        <td>{{  $familymember->patient->mdrtb_reg_year ==null ? '':$familymember->patient->mdrtb_reg_year    }}</td>
                        <td>
                            <?php 
                            $monopoly=$familymember->patient->mdrtb_monopoly
                            ?>
                            @if($monopoly==2)
                                Yes
                            @elseif($monopoly==3)
                                SG
                            @else
                                No
                            @endif
                        </td>
                          <td>
                             <?php 
                            $outside_tsp=$familymember->patient->outside_tsp
                            ?>
                            @if($outside_tsp==2)
                                Yes
                            @else
                                No
                            @endif
                        </td>
                                <td>{{$familymember->patient->name}}</td>
                                <td>{{ $familymember->patient->township->name }}</td>
                                <td>{{ $familymember->patient->township->short_code }}</td>
                                
                                 @if ($familymember->patient->township->township_group_id ==1)
                                    <td>  MDR 1</td>
                                 @elseif ($familymember->patient->township->township_group_id ==2)
                                    <td>  MDR 2</td>
                                 @else
                                     <td>''</td>
                                 @endif
                                 <td>{{$familymember->name}}</td>
                                 <td>{{$familymember->age}}</td>
                                  <td>
                                    @if( $familymember->sex==1)
                                       Male
                                     @else
                                       Female
                                     @endif
                                </td>
                                
                        @endif
                        <td>{{ $familymember->sym_screening !='0' || (int)$familymember->sym_screening > 0  ? 'Yes' : 'No' }}</td>
                        <td>
                            {{  $familymember->diag !='0' ||(int) $familymember->diag > 0 ? 'Yes' : 'No' }}
                        </td>
                        <td>
                            
                            {{ $familymember->reg_date!='0' || (int)$familymember->reg_date > 0 ? 'Yes' : 'No' }}
                        </td>
                         
                </tr>
                @endforeach
            </tbody>
            
        </table>
</body>
</html>