<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Document</title>
</head>
<body>
        <table>
            <thead>
                <tr>
                    <th>No</th>
                    <th>Code</th>
                     <th>DOTS_ID</th>
                    <th>Name</th>
                    <th>Age</th>
                    <th>Sex</th>
                    <th>Township</th>
                    <th>Township Group</th>
                    <th>Regimen</th>
                    <th>Treatment Start Date</th>
                    <th>DOT Start Date</th>
                     <th>Vol_Code</th>
                     <th>Vol_ID</th>
                    <th>Vol Name</th>
                    <th>App Use</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($dotspatients as $index=>$dotspatient)
                <tr>
                        <td>{{$index+1}}</td>
                        <td>{{ $dotspatient->patient->reg_unique_code?$dotspatient->patient->reg_unique_code:null }}</td>
                        <td>{{ $dotspatient->id }}</td>
                        <td>{{ $dotspatient->patient->name }}</td>
                        <td>{{\Carbon\Carbon::parse($dotspatient->patient->dob)->diff(\Carbon\Carbon::now())->format('%y')+1}}</td>
                      
                        <td>
                            @if( $dotspatient->patient->sex==1)
                               Male
                             @else
                               Female
                             @endif
                        </td>
                       
                        <td>{{ $dotspatient->patient->township->name }}</td>
                         
                             @if ($dotspatient->patient->township->township_group_id ==1)
                                <td>  MDR 1</td>
                             @elseif ($dotspatient->patient->township->township_group_id ==2)
                                <td>  MDR 2</td>
                             @else
                                 <td>''</td>
                             @endif
                        <td>
                            @php 
                            $mdrtbRegiments= $dotspatient->patient->mdrtbRegiments[0]['mdrtb_regiment_id'];
                            @endphp
                           @if ($mdrtbRegiments==1)
                            Conventional with PAS
                           @elseif ($mdrtbRegiments==2)
                           Conventional with PAS
                           @elseif ($mdrtbRegiments==3)
                           Individualized regimen
                           @elseif ($mdrtbRegiments==4)
                           STR
                           @elseif ($mdrtbRegiments==5)
                           Pre-XDR
                           @elseif ($mdrtbRegiments==6)
                           XDR
                           @elseif ($mdrtbRegiments==7)
                           Poly-drug resistant
                           @elseif ($mdrtbRegiments==8)
                           OLTR
                           @elseif ($mdrtbRegiments==9)
                           OSSTR
                           @elseif ($mdrtbRegiments==10)
                           BPAL
                           @elseif ($mdrtbRegiments==11)
                           BPalM
                           @elseif ($mdrtbRegiments==12)
                           LTR
                            @elseif ($mdrtbRegiments==13)
                            Mono-Drug Resistance
                           @elseif ($mdrtbRegiments==14)
                           SSTR
                           @elseif ($mdrtbRegiments==15)
                           Individualized MDR
                           @elseif ($mdrtbRegiments==16)
                           Individualized Pre-XDR
                           @else
                           ' '
                           @endif
                        </td>
                        
                        <td>{{ $dotspatient->patient->treatment_startdate }}</td>
                        <td>{{ $dotspatient->dots_startdate }}</td>
                         <td>{{ $dotspatient->volunteer?$dotspatient->volunteer->code:null }}</td>
                         <td>{{ $dotspatient->volunteer?$dotspatient->volunteer->id:null }}</td>
                        <td>{{ $dotspatient->volunteer?$dotspatient->volunteer->name:null }}</td>
                        @if($dotspatient->dots_app_status==2)
                        <td>Yes</td>
                        @else
                        <td>No</td>
                        @endif
                </tr>
                @endforeach
            </tbody>
            
        </table>
</body>
</html>