<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Document</title>
</head>
<body>
        <table>
            <thead>
                <tr>
                    <th>No</th>
                    <th>Date</th>
                    <th>Township</th>
                    <th>Township Code</th>
                    <th>Supported Township</th>
                     <th>Township Group</th>
                     
                     <th>Type</th>
                     
                    <th>Code</th>
                    <th>Year</th>
                    <th>Mono-Poly/SG</th>
                    <th>Outside Township</th>
                    
                    <th>Screening Person</th>
                    <th>Volunteer Name</th>
                    
                    <th>Name</th>
                    <th>Age</th>
                    <th>Sex</th>
                    <th>Contact Type</th>
                    
                    <th>Symptom Screening</th>
                    <th>Refer</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($cis as $index=>$ci)
                    <tr>
                        <td>{{ $index+1 }}</td>
                        <td>{{ $ci->date }}</td>
                        <td>{{ $ci->township?$ci->township->name:'' }}</td>
                        <td>{{ $ci->township?$ci->township->short_code:'' }}</td>
                        <td>{{ $ci->screening_township_id?$ci->screening_township->name:'' }}</td>
                        @if ($ci->township->township_group_id ==1)
                        <td>  MDR 1</td>
                        @elseif ($ci->township->township_group_id ==2)
                        <td>  MDR 2</td>
                        @else
                            <td>''</td>
                        @endif
                        
                        <td>
                           @if($ci->type==1 )
                                Community
                            @elseif($ci->type==2)
                                Contact
                            @else
                            
                            @endif
                       </td>
                        
                            @if($ci->patient)
                                <td>{{ $ci->patient->mdrtb_reg_no ==null ? '':$ci->patient->mdrtb_reg_no }}</td>
                                <td>{{  $ci->patient->mdrtb_reg_year ==null ? '':$ci->patient->mdrtb_reg_year    }}</td>
                                <td>
                                    <?php 
                                    $monopoly=$ci->patient->mdrtb_monopoly
                                    ?>
                                    @if($monopoly==2)
                                        Yes
                                    @elseif($monopoly==3)
                                        SG
                                    @else
                                        No
                                    @endif
                            </td>
                                <td>
                                    <?php 
                                        $outside_tsp=$ci->patient->outside_tsp
                                    ?>
                                    @if($outside_tsp==2)
                                        Yes
                                    @else
                                        No
                                    @endif
                                </td>
                            @else
                                @if($ci->presumptive)
                                    <td>{{ $ci->presumptive->index_case_no ==null ? '':$ci->presumptive->index_case_no }}</td>
                                    <td>{{ $ci->presumptive->index_case_year ==null ? '':$ci->presumptive->index_case_year }}</td>
                                    <td>
                                         <?php 
                                        $monopoly=$ci->presumptive->index_case_monopoly
                                        ?>
                                        @if($monopoly==2)
                                            Yes
                                        @elseif($monopoly==3)
                                            SG
                                        @else
                                            No
                                        @endif
                                    </td>
                                    <td></td>
                                @else
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                @endif
                            @endif
                            
                            @if($ci->screening_person=='1')
                                <td>Volunteer</td>
                                <td>{{$ci->volunteer_id!=null?$ci->volunteer->name : null}}</td>
                            @else
                                <td>FO</td>
                                <td> </td>
                            @endif
                            
                            @if($ci->presumptive)
                                <td>{{$ci->presumptive->name}}</td>
                                <td>{{$ci->presumptive->age}}</td>
                                <td>
                                    @if( $ci->presumptive->sex==1)
                                       Male
                                     @else
                                       Female
                                     @endif
                                </td>
                                <td>
                                        @if( $ci->presumptive->relationship==3)
                                           Close Contact
                                        @elseif($ci->presumptive->relationship==1)
                                           Household
                                        @endif
                                </td>
                            @else
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                            @endif
                            <td>
                                @if( $ci->symptom_screening==1)
                                   No
                                 @elseif( $ci->symptom_screening==2)
                                   Yes
                                 @else
                                 
                                 @endif
                            </td>
                             <td>
                                @if( $ci->refer==1)
                                   No
                                 @elseif( $ci->refer==2)
                                   Yes
                                 @else
                                 
                                 @endif
                            </td>
                      
                    </tr>
                @endforeach
            </tbody>
            
        </table>
</body>
</html>