<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSupVisitsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sup_visits', function (Blueprint $table) {
            $table->id();
            $table->integer("visitor_id");
            $table->string("date");
            $table->integer("type_of_visit");
            $table->string("place_of_visit")->nullable();
            $table->text("coordination")->nullable();
            $table->text("program")->nullable();
            $table->text("m_and_e")->nullable();
            $table->text("recommendation")->nullable();
            $table->integer("status")->default(1);
            $table->text("attachment")->nullable();
            $table->string("project")->nullable();
            $table->string("region_id")->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sup_visits');
    }
}
