<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateClinicPatientTreatmentsRecordsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('clinic_patient_treatments_records', function (Blueprint $table) {
            $table->id();
            $table->integer("month");
            $table->integer("smear_status");
            $table->string("smear_date")->nullable();
            $table->integer("smear_result")->nullable();
            $table->integer("culture_and_dst_status");
            $table->string("culture_and_dst_date")->nullable();
            $table->integer("culture_and_dst_result")->nullable();
            $table->integer("clinic_patient_id");
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('clinic_patient_treatments_records');
    }
}
