<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateClinicPatientVisitsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('clinic_patient_visits', function (Blueprint $table) {
            $table->increments('id');
            $table->integer("temperature");
            $table->integer("weight");
            $table->integer("covid_testing")->nullable();
            $table->string("covid_testing_date")->nullable();
            $table->integer("covid_testing_result")->nullable();
            $table->string("follow_up_note");
            $table->string("remark")->nullable();
            $table->integer("clinic_patient_id");
            $table->string("register_date");
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('clinic_patient_visits');
    }
}
