<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateClinicPatientsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('clinic_patients', function (Blueprint $table) {
            $table->id();
            $table->integer("follow_up_case");
            $table->integer("follow_up_reason");
            $table->string("otherReason")->nullable();
            $table->integer("township_id")->nullable();
            $table->string("township_name")->nullable();
            $table->string("name");
            $table->integer("age");
            $table->integer("sex");
            $table->string("phone");
            $table->string("address");
            $table->string("tb_code");
            $table->string("tb_year");
            $table->string("code");
            $table->integer("registeration_group");
            $table->string("transfer_in_township");
            $table->integer("first_xpert_status");
            $table->string("first_xpert_date")->nullable();
            $table->integer("first_xpert_result")->nullable();
            $table->integer("second_xpert_status")->nullable();
            $table->string("second_xpert_date")->nullable();
            $table->integer("second_xpert_result")->nullable();
            $table->integer("dst_status")->nullable();
            $table->string("dst_date")->nullable();
            $table->string("dst_lab_no")->nullable();
            $table->integer("dst_result")->nullable();
            $table->string("susceptible_to")->nullable();
            $table->string("resistant_to")->nullable();
            $table->integer("hiv_status")->nullable();
            $table->string("hiv_date")->nullable();
            $table->integer("hiv_result")->nullable();
            $table->integer("cpt_status")->nullable();
            $table->string("cpt_date")->nullable();
            $table->integer("art_status")->nullable();
            $table->string("art_date")->nullable();
            $table->integer("treatment_outcome")->nullable();
            $table->string("outcome_date")->nullable();
            $table->integer("comorbid_dm")->nullable();
            $table->string("comorbid_other")->nullable();
            $table->integer("status")->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('clinic_patients');
    }
}
