<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDotsVisitDatesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('dots_visit_dates', function (Blueprint $table) {
            $table->id();
            $table->integer("status");
            $table->integer("dots_patient_id");
            $table->integer("volunteer_id");
            $table->integer("type");
            $table->date("date");
            $table->string("low_side_effect")->nullable();
            $table->string("high_side_effect")->nullable();
            $table->double("duration");
            $table->text("signature");
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('dots_visit_dates');
    }
}
