<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCounselingActivitiesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('counseling_activities', function (Blueprint $table) {
            $table->id();
            $table->integer("month");
            $table->integer("year");
            $table->integer("township_id");
            $table->date("date");
            $table->string("phone");
            $table->integer("patient_id");
            $table->integer("less_than_5_count")->nullable();
            $table->integer("between_5_and_14_count")->nullable();
            $table->integer("greate_than_15")->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('counseling_activities');
    }
}
