<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSupervisionVisitActivitiesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('supervision_visit_activities', function (Blueprint $table) {
            $table->id();
            $table->integer("month");
            $table->integer("year");
            $table->integer("township_id");
            $table->integer("patient_id");
            $table->integer("volunteer_id");
            $table->integer("dots_type");
            $table->integer("supervision_type");
            $table->json("radio_value_list");
            $table->date("date");
            $table->string("remark")->nullable();
            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('supervision_visit_activities');
    }
}
