<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateHeActivitiesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('he_activities', function (Blueprint $table) {
            $table->id();
            $table->integer("type");
            $table->integer("n_o_attendence_male");
            $table->integer("n_o_attendence_female");
            $table->integer("index_case_no")->nullable();
            $table->integer("index_case_year")->nullable();
            $table->string("index_case_initial")->nullable();
            $table->string("place");
            $table->string("remark")->nullable();
            $table->date("date");
            $table->integer("volunteer_id")->nullable();
            $table->integer("month");
            $table->integer("year");
            $table->integer("township_id");
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('he_activities');
    }
}
