<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePresumptiveDiagnosesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('presumptive_diagnoses', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer("presumptive_id");
            $table->integer("times")->default(1);
            $table->integer("hiv_status");
            $table->date("hiv_date")->nullable();
            $table->string("hiv_result")->nullable();
            $table->string("hiv_code")->nullable();
            $table->integer("sputum_status");
            $table->date("sputum_date")->nullable();
            $table->string("sputum_result")->nullable();
            $table->integer("cxr_status");
            $table->date("cxr_date")->nullable();
            $table->string("cxr_result")->nullable();
            $table->integer("gene_xpert_status");
            $table->date("gene_xpert_date")->nullable();
            $table->string("gene_xpert_result")->nullable();
            $table->integer("culture_status");
            $table->date("culture_date")->nullable();
            $table->string("culture_result")->nullable();
            $table->integer("dst_status");
            $table->date("dst_date")->nullable();
            $table->string("dst_result")->nullable();
            $table->integer("other_investigation_status");
            $table->date("other_investigation_date")->nullable();
            $table->string("other_investigation_test")->nullable();
            $table->string("other_investigation_result")->nullable();
            $table->string("conclusion");
            $table->string("conclusion_code")->nullable();
            $table->string("other_comment")->nullable();
            $table->integer("status")->default(1);
            $table->date("register_date");
            $table->integer("referral_type_id");
            $table->integer("referral_from_id");
            $table->integer("refer_id")->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('presumptive_diagnoses');
    }
}
