<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePresumptivesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('presumptives', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string("name")->nullable();
            $table->integer("age")->nullable();
            $table->integer("sex")->nullable();
            $table->integer("township_id");
            $table->integer("case_found_at");
            $table->integer("index_case_no")->nullable();
            $table->integer("index_case_year")->nullable();
            $table->string("index_case_initial")->nullable();
            $table->integer("relationship")->nullable();
            $table->date("referral_date")->nullable();
            $table->integer("referral_from_id")->nullable();
            $table->string("previousID")->nullable();
            $table->integer("serial")->nullable();
            $table->string("unique_number")->nullable();
            $table->integer("status")->default(1);
            $table->integer("volunteer_id")->nullable();
            $table->integer("patient_id")->nullable();
            $table->integer("confirm");
            $table->integer("existing_presumptive")->default(0);
            $table->integer("existing_presumptive_id")->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('presumptives');
    }
}
