<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEnrollSupportsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('enroll_supports', function (Blueprint $table) {
            $table->id();
            $table->integer("nominated");
            $table->integer("support")->nullable();
            $table->integer("support_month");
            $table->integer("support_year");
            $table->date("date")->nullable();
            $table->string("signature")->nullable();
            $table->integer("status")->default(1);
            $table->integer("patient_id");
            $table->integer("type")->nullable();
            $table->integer("delagated")->default(1);
            $table->integer("delagated_person_id")->nullable();
            $table->integer("repay")->default(1);
            $table->string("remark")->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('enroll_supports');
    }
}
