<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePreEnrollSupportsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('pre_enroll_supports', function (Blueprint $table) {
            $table->id();
            $table->integer("nominated");
            $table->integer("support")->nullable();
            $table->integer("support_month");
            $table->integer("support_year");
            $table->date("date")->nullable();
            $table->string("signature")->nullable();
            $table->integer("status")->default(1);
            $table->integer("patient_id");
            $table->integer("delagated")->default(1);
            $table->integer("delagated_person_id")->nullable();
            $table->integer("repay")->default(1);
            $table->integer("month_type");
            $table->integer("type")->nullable();
            $table->string("remark")->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('pre_enroll_supports');
    }
}
