<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePatientsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('patients', function (Blueprint $table) {
            $table->id();
            $table->string("name");
            $table->string("sex");
            $table->date("dob");
            $table->string("address");
            $table->string("lab_test_name")->nullable();
            $table->string("lab_result")->nullable();
            $table->string("lab_code")->nullable();
            $table->date("lab_date")->nullable();
            $table->integer("pre_enroll");
            $table->integer("township_id");
            $table->integer("outside_tsp")->nullable();
            $table->string("outside_tsp_name")->nullable();

            $table->integer("mdrtb_reg_no")->nullable();
            $table->integer("mdrtb_reg_year")->nullable();
            $table->string("mdrtb_reg_initial")->nullable();


            $table->integer("type_of_patient")->nullable();
            $table->integer("type_of_tb")->nullable();
            $table->date("treatment_startdate")->nullable();
            

            $table->integer("t_in")->nullable();
            $table->date("t_in_date")->nullable();
            $table->integer("t_in_type")->nullable();
            $table->integer("t_in_township_id")->nullable();
            $table->string("t_in_township_name")->nullable();

            $table->integer("lpa_result")->nullable();
            $table->date("lpa_date")->nullable();

            $table->integer("hiv_status")->nullable();
            $table->date("hiv_date")->nullable();
            $table->string("hiv_result")->nullable();
            $table->integer("art_rx")->nullable();
            $table->integer("cpt_rx")->nullable();
            $table->date("art_rx_date")->nullable();
            $table->date("cpt_rx_date")->nullable();

            $table->integer("treatment_finish")->nullable();
            $table->date("finished_date")->nullable();
            $table->string("final_outcome")->nullable();
            $table->date("final_outcome_date")->nullable();
            $table->date("issue_date")->nullable();
            $table->date("change_finished_date")->nullable();

            $table->date("support_startdate")->nullable();

            $table->string("gene_code")->nullable();
            $table->integer("gene_result")->nullable();
            $table->date("gene_date")->nullable();

            $table->integer("cxr_result")->nullable();
            $table->date("cxr_date")->nullable();

            $table->integer("culture_result")->nullable();
            $table->date("culture_date")->nullable();

            $table->string("remark")->nullable();
            $table->string("support_remark")->nullable();
            $table->integer("status")->default(1);


            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('patients');
    }
}
