<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateVolunteersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('volunteers', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string("name");
            $table->string("age");
            $table->string("code");
            $table->string("gender");
            $table->string("address");
            $table->string("phone");
            $table->string("phone2")->nullable();
            $table->string("education_status");
            $table->string("occupation");
            $table->string("remark")->nullable();
            $table->string("password");
            $table->string("plain_password");
            $table->integer("status")->default(1);
            $table->integer("township_id");
            $table->integer("both_mdr_picts")->default(1);
            $table->integer("serial");
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('volunteers');
    }
}
