<?php

namespace App\Service\VolApp;

class CustomClassContainer
{
    protected $model;
    public function __construct($model)
    {
        $this->model = $model;
    }

    public function getEach($column = null, $value = null)
    {
        if ($column && $value)
            return $this->model->where($column, $value)->first();
        else
            return $this->model->first();
    }

    public function filter($filters, $data)
    {
        foreach ($filters as $filter) {
            if (isset($data[$filter])) $this->model = $this->model->where($filter, $data[$filter]);
        }
    }

    public function modelFilter($filters, $data, $model)
    {
        foreach ($filters as $filter) {
            if (isset($data[$filter])) $model = $model->where($filter, $data[$filter]);
        }

        return $model;
    }

    public function orderData($column, $type)
    {
        $this->model = $this->model->orderBy($column, $type);
    }

    public function last_insert()
    {
        $this->model = $this->model->orderBy("id", "desc");
        return $this->model->first();
    }
}
