<?php

namespace App\Service\Supervision;

use App\Service\Utils\FileService;

class Visit extends CustomClassContainer
{
    function __construct()
    {
        parent::__construct(new \App\Models\SupVisit);
    }

    public function save()
    {
        $insertedData = [
            'visitor_id' => request()->user()->id,
            'date' => request("date"),
            'type_of_visit' => request("type_of_visit"),
            'place_of_visit' => request("place_of_visit"),
            'coordination' => request("coordination"),
            'program' => request("program"),
            'm_and_e' => request("m_and_e"),
            'recommendation' => request("recommendation"),
        ];



        if (request("attachment") && request("attachment") != null && request("attachment") != "null") {
                
            $file = FileService::save(request("attachment"), "supvisits/attachments");
            $insertedData["attachment"] = $file;
               
        }

        $result = $this->model->create($insertedData);
        $result->townships()->attach(request("township_ids"));



        if (request("co_visitors")) {
            $data["co_visitors"] = request("co_visitors");
            $result->co_visitors()->attach($data["co_visitors"]);
            
        }
        $this->saveCount($result->id);



        return $result;
    }

    public function saveCount($visitID)
    {
        if (request("co_visitors")){
            foreach (request("township_ids") as $townshipID) {
                foreach (request("co_visitors") as $coVisitor) {
                    \App\Models\SupVisitCount::create([
                        "member_id" => $coVisitor,
                        "all_township_id" => $townshipID,
                        "sup_visit_id" => $visitID
                    ]);
                }
            }
        }
        
        foreach (request("township_ids") as $townshipID) {
            if (request()->user()->role != 1) {
                \App\Models\SupVisitCount::create([
                    "member_id" => request()->user()->id,
                    "all_township_id" => $townshipID,
                    "sup_visit_id" => $visitID
                ]);
            }
        }
    }

    public function update()
    {
        $model = $this->getEach("id", request("id"));
        $insertedData = [
            'visitor_id' => request()->user()->id,
            'date' => request("date"),
            'type_of_visit' => request("type_of_visit"),
            'place_of_visit' => request("place_of_visit"),
            'coordination' => request("coordination"),
            'program' => request("program"),
            'm_and_e' => request("m_and_e"),
            'recommendation' => request("recommendation"),
        ];
          if (request("attachment") && request("attachment") != null && request("attachment") != "null") {
            $file = FileService::save(request("attachment"), "supvisits/attachments");
            $insertedData["attachment"] = $file;
        }
        $result = $model->update($insertedData);

        $model->townships()->detach();
        $model->townships()->attach(request("township_ids"));
        $model->co_visitors()->detach();

        \App\Models\SupVisitCount::where("sup_visit_id", request("id"))->delete();





        if (request("co_visitors")) {
            $data["co_visitors"] = request("co_visitors");
            $model->co_visitors()->attach($data["co_visitors"]);
            
        }
        $this->saveCount($model->id);




        return $result;
    }

    public function withColumn()
    {
        $this->model = $this->model->with([
            "visitor", "townships", "co_visitors"
        ]);
    }

    public function getEach($column = null, $value = null)
    {
        $this->withColumn();
        return $this->model->where($column, $value)->first();
    }


    public function getAll()
    {
        $this->withColumn();
        $this->filter(["id", "date"], request()->all());

        if (request("me")) {
            $this->model = $this->model->where("visitor_id", request()->user()->id);
        } else {
            $this->model = $this->model->where("visitor_id", "!=", request()->user()->id);
        }

        if (request("role")) {
            $this->model = $this->model->whereHas("visitor", function ($query) {
                $query->where("role", request("role"));
            });
        }

        if (request("member")) {
            $this->model = $this->model->where("visitor_id", request("member"));
        }

        if (request("startDate") && request("endDate")) {
            $this->model = $this->model->whereBetween("date", [request("startDate"), request("endDate")]);
        }

        return $this->model->where("status", 1)->get();
    }

    public function delete($id)
    {
        $model = $this->getEach("id", $id);
        $model->status = 0;
        $model->update();
        $model->townships()->detach();
        $model->co_visitors()->detach();
        \App\Models\SupVisitCount::where("sup_visit_id", $id)->delete();

        return true;
    }
}
