<?php

namespace App\Service\Supervision;

class Township extends CustomClassContainer
{
    function __construct()
    {
        parent::__construct(new \App\Models\AllTownship);
    }

    public function getAll()
    {
        $this->filter(["id"], request()->all());

        $this->model = $this->model->orderBy("id");
        
        //retrieve all townships for PICTS2
        if (request()->user()->role == 5 && request()->project === "PICTS2") {
            $this->model = $this->model->where("id",17)->orWhere("id",31)->orWhere("id",25)->orWhere("id",14)->orWhere("id",32)->orWhere("id",12)->orWhere("id",13);
        }

        if (request()->user()->role == 2 || request()->user()->role == 4 || request()->user()->role == 5) {
                $this->model = $this->model->where(function ($query) {
                    $query->where("project", 3)->orWhere("project", request()->user()->project);
                });
        }

        

        if (request("region_id")) {
            $this->model = $this->model->where("region_id", request("region_id"));
        }

        if (request("project")) {
            if (request("project") == "PICTS")   $this->model = $this->model->where(function ($query) {
                $query->where("project", 3)->orWhere("project", 1);
            });
            else if (request("project") == "MDR")   $this->model = $this->model->where(function ($query) {
                $query->where("project", 3)->orWhere("project", 2);
            });
            else if (request("project") == "PICTS1")   $this->model = $this->model->where(function ($query) {
                $query->where("project", 3)->orWhere("project", 1);
            })->where("township_group_id", 1)->where("id", "!=", 14)->where("id", "!=", 12);
            else if (request("project") == "PICTS2")   $this->model = $this->model->where("id",17)->orWhere("id",31)->orWhere("id",25)->orWhere("id",14)->orWhere("id",32)->orWhere("id",12)->orWhere("id",13);
            else if (request("project") == "MDR1")   $this->model = $this->model->where(function ($query) {
                $query->where("project", 3)->orWhere("project", 2);
            })->where("township_group_id", 1);
            else if (request("project") == "MDR2")   $this->model = $this->model->where(function ($query) {
                $query->where("project", 3)->orWhere("project", 2);
            })->where("township_group_id", 2);
        }
        
        $townships=$this->model->get();
    
        if (request()->user()->id == 35 && request("region_id")==5) {
            $addedTownship=\App\Models\AllTownship::where("id",12)->orWhere("id",13)->get();
            $townships=$addedTownship->toArray();
        }
        
        if (request()->user()->id == 35 && request("region_id")==4) {
            $addedTownship=\App\Models\AllTownship::where("id",14)->orWhere("id",15)->orWhere("id",32)->get();
            $townships=$addedTownship->toArray();
        }



        return $townships;
    }
}
