<?php

namespace App\Service\Supervision;

class Report
{
    public function get()
    {
        $data = \App\Models\SupVisitCount::groupBy('all_township_id')
            ->selectRaw('count(*) as total, all_township_id')
            ->where("member_id", request("member_id"))
            ->with(["township","member"])
            ->whereHas("sup_visit", function ($query) {
                if (request("startDate") && request("endDate")) {
                    $query->whereBetween("date", [request("startDate"), request("endDate")]);
                }
            })
            ->orderBy("all_township_id")
            ->get();
        return $data;
    }
}
