<?php

namespace App\Service\Supervision;

use App\Service\Utils\FileService;

class Feedback extends CustomClassContainer
{
    function __construct()
    {
        parent::__construct(new \App\Models\SupVisitFeedback);
    }

    public function save()
    {
        $insertedData = [
            'member_id' => request()->user()->id,
            'sup_visit_id' => request("sup_visit_id"),
            'body' => request("body"),
        ];
        $result = $this->model->create($insertedData);
        return $result;
    }

    public function update()
    {
        $model = $this->getEach("id", request("id"));
        $insertedData = [
            'member_id' => request()->user()->id,
            'sup_visit_id' => request("date"),
            'body' => request("body"),
        ];
        $model->update($insertedData);
        return $model;
    }

    public function withColumn()
    {
        $this->model = $this->model->with([
            "member"
        ]);
    }

    public function getEach($column = null, $value = null)
    {
        $this->withColumn();
        return $this->model->where($column, $value)->first();
    }


    public function getAll()
    {
        $this->withColumn();
        $this->filter(["id", "sup_visit_id"], request()->all());
        return $this->model->get();
    }

    public function delete($id)
    {
        $model = $this->getEach("id", $id);
        $model->delete();
        return true;
    }
}
