<?php

namespace App\Service\PA;

class Volunteer extends CustomClassContainer
{

    function __construct()
    {
        parent::__construct(new \App\Models\Volunteer());
    }

    public function save($data)
    {
        $data["serial"] = $this->getSerial();
        $password = rand(10000, 99999);
        return $this->model->create([
            "name" => $data["name"],
            "age" => $data["age"],
            "gender" => $data["gender"],
            "address" => $data["address"],
            "phone" => $data["phone"],
            "phone2" => $data["phone2"],
            "education_status" => $data["education_status"],
            "occupation" => $data["occupation"],
            "remark" => $data["remark"],
            "township_id" => request()->user()->township_id,
            "password" => bcrypt($password),
            "plain_password" => $password,
            "serial" => $data["serial"],
            "code" => $this->generateVolunteer($data["serial"], request()->user()->township_id),
            "both_mdr_picts" => $data["both_mdr_picts"],
            "joining_date" => $data["joining_date"],
            "nrc_no" => $data["nrc_no"],
            "father_name" => $data["father_name"],
             "global_id" => $data["global_id"],
        ]);
    }

    public function getSerial()
    {
        $latest = $this->model->orderBy("serial", "desc")->where("township_id",request()->user()->township_id)->first();
        return $latest ? $latest->serial + 1 : 1;
    }

    public function generateVolunteer($serial, $township_id)
    {
       
        $code = "V";
        $township = \App\Models\Township::find($township_id);
        
        if ($township) {
            $code .= $township->short_code;
        }
        
        $serial = str_pad($serial, 5, '0', STR_PAD_LEFT);
        $code .= $serial;
 
        return $code;

    }

    public function withColumn()
    {
        $this->model = $this->model->with([
            "township",
            "trainings" => function ($query) {
                $query->where("status", 1);
            }
        ]);
    }

    public function getEach($column = null, $value = null)
    {
        $this->withColumn();
        return $this->model->where($column, $value)->first();
    }


    public function getAll($data)
    {
        $this->withColumn();
        $this->filter(["code", "id", "township_id", "gender", "phone"], $data);
        if (request("search")) {
            $this->model = $this->model->where(function ($query) {
                $query->where("name", "like", request("search") . "%")->orWhere("code", "like", request("search") . "%")->orWhere("code", "like", request("search") . "%");
            });
        }

        if (request("startDate") && request("endDate")) {
            $this->model = $this->model->whereHas("trainings", function ($query) {
                $query->whereBetween("date", [request("startDate"), request("endDate")]);
                if (request("training_type_id")) {
                    $query->where("training_type_id", request('training_type_id'));
                }
                if (request("type")) {
                    $query->where("type", request('type'));
                }

                $query->where("status", 1);
            });
        }
        
        if (request("township_id")) {
            return $this->model->where("status", 1)
            ->where("township_id",request("township_id"))
            ->get();
        }

        return $this->model->where("status", 1)
            ->where("township_id", request()->user()->township_id)
            ->get();
    }


    public function update($data)
    {
        $model = $this->getEach("id", $data["id"]);
        return $model->update([
            "name" => $data["name"],
            "age" => $data["age"],
            "gender" => $data["gender"],
            "address" => $data["address"],
            "phone" => $data["phone"],
            "phone2" => $data["phone2"],
            "education_status" => $data["education_status"],
            "occupation" => $data["occupation"],
            "remark" => $data["remark"],
            "both_mdr_picts" => $data["both_mdr_picts"],
            "joining_date" => $data["joining_date"],
            "nrc_no" => $data["nrc_no"],
            "father_name" => $data["father_name"],

        ]);
    }

    public function changeStatus($id, $status)
    {
        $model = $this->getEach("id", $id);
        $model->status = $status;
        $model->update();
        return true;
    }

    public function delete($id)
    {

        return $this->changeStatus($id, 0);
    }

    public function recover($id)
    {
        return $this->changeStatus($id, 1);
    }

    public function trash($data)
    {
        $this->withColumn();
        $this->filter(["name", "code"], $data);
        return $this->model->where("status", 0)->get();
    }
}
