<?php

namespace App\Service\PA;

class Presumptive extends CustomClassContainer
{

    function __construct()
    {
        parent::__construct(new \App\Models\Presumptive());
    }

    public function getByIndexCode($data)
    {
        $this->model = $this->model->where("index_case_no", $data["index_case_no"])->where("index_case_year", $data["index_case_year"]);
        
        
        if ($data["index_case_initial"]) {
            $this->model = $this->model->where("index_case_initial", $data["index_case_initial"]);
        }
        return $this->model->where("township_id", request()->user()->township_id)->where("status", 1)->get();
    }



    public function getAll($data)
    {
        $this->filter(["township_id"], $data);
        $this->withColumns();
        return $this->model->where("status", 1)->where("confirm", 1)->where("township_id", request()->user()->township_id)->get();
    }

    public function getReferList($data)
    {
        $this->withColumns();
        $this->filter(["patient_id", "volunteer_id", "township_id"], $data);
        return $this->model->where("status", 1)->where("volunteer_id", "!=", NULL)->get();
    }



    public function withColumns()
    {
        $this->model = $this->model->with(
            [

                "case_found_at_name",
                "township",




                "diagonsis" => function ($query) {
                    $query->where('status', 1);
                    $query->with(
                        [
                            "symptons",
                            "risk_factors",
                            "hiv_result_name",
                            "sputum_result_name",
                            "gene_xpert_result_name",
                            "culture_result_name",
                            "dst_result_name",
                            "cxr_result_name",
                            "conclusion_name",
                            "refer_from_name",
                            "refer_type_name",

                        ]
                    );
                }
            ]
        );
    }



    public function getEach($column = null, $value = null)
    {
        $this->withColumns();
        return $this->model->where($column, $value)->where("township_id", request()->user()->township_id)->first();
    }
}
