<?php

namespace App\Service\PA;

class PatientMDRTBRegiment extends CustomClassContainer
{

    function __construct()
    {
        parent::__construct(new \App\Models\PatientMdrtbRegiment());
    }

    public function save($data)
    {
        $insertedData = [
            'patient_id' => $data["patient_id"],
            'mdrtb_regiment_id' => $data["mdrtb_regiment_id"],
            'mdrtb_regiment_text' => $data["mdrtb_regiment_text"],
            'mdrtb_regiment_other'=>$data["mdrtb_regiment_other"],
            'date' => $data["date"],
        ];
        return $this->model->create($insertedData);
    }



    public function withColumn()
    {
        $this->model = $this->model->with([
            "patient"
        ]);
    }

    public function getEach($column = null, $value = null)
    {
        $this->withColumn();
        return $this->model->where($column, $value)->first();
    }


    public function getAll($data)
    {
        $this->withColumn();
        $this->filter(["patient_id"], $data);
        return $this->model->get();
    }


    public function update($data)
    {
        $model = $this->getEach("id", $data["id"]);
        $insertedData = [
            'patient_id' => $data["patient_id"],
            'mdrtb_regiment_id' => $data["mdrtb_regiment_id"],
            'mdrtb_regiment_text' => $data["mdrtb_regiment_text"],
            'mdrtb_regiment_other'=>$data["mdrtb_regiment_other"],
            'date' => $data["date"],
        ];
        return $model->update($insertedData);
    }



    public function delete($id)
    {
        $model = $this->getEach("id", $id);
        $model->delete();
        return true;
    }
}
