<?php

namespace App\Service\PA;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Model;

class Patient extends CustomClassContainer
{

    function __construct()
    {
        parent::__construct(new \App\Models\Patient());
    }

    public function save($data)
    {
        return $this->model->create([
            "name" => $data["name"],
            "sex" => $data["sex"],
            "dob" => $data["dob"],
            "address" => $data["address"],
            "lab_result" => $data["lab_result"],
            "lab_date" => $data["lab_date"],
            "lab_code" => $data["lab_code"],
            "lab_test_name" => $data["lab_test_name"],
            "pre_enroll" => $data["pre_enroll"],
            "gene_result" => $data["gene_result"],
            "gene_code" => $data["gene_code"],
            "gene_date" => $data["gene_date"],
            "gene_result_receive_date"=>$data["gene_result_receive_date"],
            "township_id" => request()->user()->township_id,
        ]);
    }

    public function withColumn($exported = false)
    {

        $withColumns = [
            "township", "mdrtbRegiments" => function ($query) {
                $query->orderBy("created_at", "desc");
            },"comorbid_diseases", "family_members",
            "dots_patient" => function ($query) {
                
                $query->with('dots_visit_date')->orderBy("created_at", "desc");
            },
        ];

        if ($exported) {
            $withColumns["enroll_supports"] = function ($query) {
                $query->where("status", 1)->orderBy("support_month")->orderBy("support_year");
            };

            $withColumns["pre_enroll_supports"] = function ($query) {
                $query->where("status", 1)->orderBy("support_month")->orderBy("support_year");
            };

            array_push($withColumns,"transfer_in_township");
        }

        $this->model = $this->model->with($withColumns);
    }

    public function getEach($column = null, $value = null)
    {
        $this->withColumn();
        $data = $this->model->where($column, $value)->first();
        
        // $data = DB::select('SELECT  patients.*
        //                     FROM patients
        //                     JOIN townships ON patients.township_id = townships.id
        //                     WHERE patients.status = 1 AND patients.id = ? AND patients.township_id = ? ', [$value,request()->user()->township_id]);
        
        // $combo= DB::select('SELECT  patient_comorbid_diseases.*
        //                     FROM patient_comorbid_diseases
        //                     WHERE patient_id = ? ', [$value]);
        
        $combo = $data["comorbid_diseases"];
        //  array_push($comboArr, $item->comorbid_diseases_id);
        
        $comboArr = [];
        foreach ($combo as $item) {
            array_push($comboArr, $item["comorbid_diseases_id"]);
        }
        unset($data["comorbid_diseases"]);
        $data["comorbid_diseases"] = $comboArr;
        return $data;
    }
    
      public function getPowerBiData($column)
    {
        $this->withColumn();
        $data = $this->model->get();
        return $data;
    }

    public function getAll($data, $exported = false)
    {
      
       // $this->withColumn(true);
        $this->filter(["township_id", "name", "sex"], $data);
        
        $this->model=$this->model->with([
              "township",
            "dots_patient" => function ($query) {
                        $query->with('dots_visit_date');
                    },
              ]);
              
        
        if (request("search")) {
            $this->model = $this->model->where(function ($query) {
                $query->where("name", "like", request("search") . "%");
            });
        }

        if (request("support_type")) {
            if (request("support_type") == 1) {
                $this->model = $this->model->whereHas("pre_enroll_supports", function ($query) {
                    $query->whereBetween("date", [request("support_startdate"), request("support_enddate")]);
                });
            } else if (request("support_type") == 2) {
                $this->model = $this->model->whereHas("enroll_supports", function ($query) {
                    $query->whereBetween("date", [request("support_startdate"), request("support_enddate")]);
                });
            }
        }

        if (request("mdrtb_reg_no") && request("mdrtb_reg_year")) {
            $this->model = $this->model->where("mdrtb_reg_no", request("mdrtb_reg_no"))->where("mdrtb_reg_year", request("mdrtb_reg_year"));
        }

        if (request("onGoingEndDate")) {
            $this->model = $this->model->where(function ($query) {

                $query->where("finished_date", ">", request("onGoingEndDate"))->orWhere("finished_date", null);
            });
        }

        if (request("nominated_month") && request("nominated_year")) {
            $month = request("nominated_month");
            if ($month < 10) {
                $month = '0' . $month;
            }
            $nominatedDate = request("nominated_year") . '-' . $month . '-' . '01';
            $this->model = $this->model->where("finished_date", ">", $nominatedDate)->where("treatment_startdate", "<=", $nominatedDate);
        }

        if (request("volunteer_id")) {
            $this->model = $this->model->whereHas("dots_patient", function ($query) {
                $query->whereHas("dots_main_acitivty", function ($query) {
                    $query->where("volunteer_id", request("volunteer_id"));
                });
            });
        }
      
        if ($exported) {
            $result = $this->model->where(["status"=> 1, "township_id" => request()->user()->township_id])->get();
            return $result;
        }
        
        $limit = 30;
        $page = 0;
        $total = $this->model->where("status", 1)->where("township_id", request()->user()->township_id)->count();
        $page = (int)($total / $limit);
        if ($total % $limit != 0) {
            $page += 1;
        }
        $currentPage = request()->page ? request()->page : 1;
        $skipStart = 0;
        if ($currentPage > 1) {
            $skipStart = ($limit * ($currentPage - 1));
        }
        
        ///select patients 
        $patients = DB::select('SELECT  patients.id,patients.name,patients.mdrtb_reg_no,patients.mdrtb_reg_year,patients.dob,patients.sex,patients.pre_enroll,
                                patients.mdrtb_monopoly,patients.remark,patients.finished_date,townships.name AS township ,townships.id as symptom_screening
                                FROM patients
                                JOIN townships ON patients.township_id = townships.id
                               
                                WHERE patients.status = 1 AND patients.township_id = ? 
                                LIMIT ?, ?', [request()->user()->township_id, $skipStart, $limit]);
        
            foreach ($patients as $patient) {
                if (!$patient->finished_date) {
                   $is_auto_nominated=true;
                    $current = \Carbon\Carbon::now();
                    $finishedDate = \Carbon\Carbon::parse($patient->finished_date);
                    if ($current < $finishedDate) 
                    {
                         $is_auto_nominated=true;
                    }
                    else {
                        $is_auto_nominated=false;
                    }
                }
                else{
                     $is_auto_nominated=false;
                }
                $patient->is_auto_nominated=$is_auto_nominated;
            }
                          
        //$patients=$this->model->where("status", 1)->where("township_id", request()->user()->township_id)->skip($skipStart)->take($limit)->get();
        
        //   foreach($patients as $dots)
        //   {
        //       $symptom_screening=0;
        //       foreach($dots->dots_patient as $visits)
        //       {
        //           foreach($visits->dots_visit_date as $symptom)
        //           {
        //                 $sideEffects = explode(',', $symptom->high_side_effect);

        //                     if (in_array(3, $sideEffects) || in_array(4, $sideEffects)) {
        //                         $symptom_screening++;
        //                     }
        //               }
                  
        //       }
              
        //       $dots['symptom_screening']=$symptom_screening;
        //   }
       // $result = $this->model->where("status", 1)->where("township_id", request()->user()->township_id)->skip($skipStart)->paginate($limit);
        //$result = $this->model->where("status", 1)->where("township_id", request()->user()->township_id)->skip($skipStart)->take($limit)->get();
        
        return [
            "result" => $patients,
            "total" => $total,
            "page" => $page,
        ];
        
      
    }


    public function update($data)
    {
        $model = $this->getEach("id", $data["id"]);
        $this->model->update([
            "name" => $data["name"],
            "sex" => $data["sex"],
            "dob" => $data["dob"],
            "address" => $data["address"],
            "lab_result" => $data["lab_result"],
            "lab_date" => $data["lab_date"],
            "lab_code" => $data["lab_code"],
            "lab_test_name" => $data["lab_test_name"],
            "pre_enroll" => $data["pre_enroll"],
            "gene_result" => $data["gene_result"],
            "gene_code" => $data["gene_code"],
            "gene_date" => $data["gene_date"],
            "gene_result_receive_date"=>$data["gene_result_receive_date"],
            "remark" => $data["remark"],
            "township_id" => request()->user()->township_id,

        ]);

        return $model;
    }



    public function delete($id)
    {
        $model = $this->model->find($id);
        $model->status = 0;
        $model->update();
        return true;
    }

    public function updateSupportInformation($data)
    {
        $model = $this->getEach("id", $data["id"]);
        $insertedData = [
            'outside_tsp' => $data["outside_tsp"],
            't_in' => $data["t_in"],
            'mdrtb_reg_no' => (int)$data["mdrtb_reg_no"],
            'mdrtb_reg_year' => $data["mdrtb_reg_year"],
            'mdrtb_monopoly'=>  $data["mdrtb_monopoly"],
            'type_of_patient' => $data["type_of_patient"],
            'subtype_patient_rx' => $data["subtype_patient_rx"],
            'subtype_patient_other' => $data["subtype_patient_other"],
            'type_of_tb' => $data["type_of_tb"],
            'lpa_code' => $data["lpa_code"],
            'lpa_result_h' => $data["lpa_result_h"],
            'lpa_result_s' => $data["lpa_result_s"],
            'lpa_result_r' => $data["lpa_result_r"],
            'lpa_result_e' => $data["lpa_result_e"],
            'lpa_result_amk' => $data["lpa_result_amk"],
            'lpa_result_km' => $data["lpa_result_km"],
            'lpa_result_cm' => $data["lpa_result_cm"],
            'lpa_result_fq' => $data["lpa_result_fq"],
            'lpa_result_contaminated' => $data["lpa_result_contaminated"],
            'lpa_date' => $data["lpa_date"],
            'xpert_mtb' => $data["xpert_mtb"],
            'xpert_mtb_code' => $data["xpert_mtb_code"],
            'xpert_mtb_date' => $data["xpert_mtb_date"],
            'xpert_mtb_h' => $data["xpert_mtb_h"], 
            'xpert_mtb_am' => $data["xpert_mtb_am"], 
            'xpert_mtb_km' => $data["xpert_mtb_km"], 
            'xpert_mtb_cm' => $data["xpert_mtb_cm"], 
            'xpert_mtb_fq' => $data["xpert_mtb_fq"], 
            'xpert_mtb_eth' => $data["xpert_mtb_eth"], 
            'hiv_status' => $data["hiv_status"],
            'comorbid_diseases_other' => $data["comorbid_diseases_other"],
            'cxr_result' => $data["cxr_result"],
            'culture_result' => $data["culture_result"],
            'culture_code' => $data["culture_code"],
            'cxr_date' => $data["cxr_date"],
            'culture_date' => $data["culture_date"],
            'treatment_startdate' => $data["treatment_startdate"],
            'support_remark' => $data["support_remark"],
            'support_startdate'=>isset($data["support_startdate"])?$data["support_startdate"]:null,

        ];

        if (isset($data["mdrtb_reg_initial"])) {
            $insertedData["mdrtb_reg_initial"] = $data["mdrtb_reg_initial"];
        }

        \App\Models\PatientComorbidDisease::where("patient_id", $data["id"])->delete();

        foreach ($data["comorbid_diseases"] as $item) {
            \App\Models\PatientComorbidDisease::create([
                "patient_id" => $data["id"],
                "comorbid_diseases_id" => $item
            ]);
        }

        if ($data["outside_tsp"] == 2) {
            $insertedData["outside_tsp_name"] = $data["outside_tsp_name"];
        } else {
            $insertedData["outside_tsp_name"] = NULL;
        }

        if ($insertedData["t_in"] == 1) {
            $insertedData["t_in_date"] = NULL;
            $insertedData["t_in_type"] = NULL;
            $insertedData["t_in_township_id"] = NULL;
            $insertedData["t_in_township_name"] = NULL;
        } else {
            $insertedData["t_in_date"] = $data["t_in_date"];
            $insertedData["t_in_type"] = $data["t_in_type"];

            if ($data["t_in_type"] == 1) {
                $insertedData["t_in_township_id"] = $data["t_in_township_id"];
                $insertedData["t_in_township_name"] = NULL;
            } else if ($data["t_in_type"] == 2) {
                $insertedData["t_in_township_name"] = $data["t_in_township_name"];
                $insertedData["t_in_township_id"] = NULL;
            }
        }

        if ($data["hiv_status"] == 2) {
            $insertedData["hiv_date"] = $data["hiv_date"];
            $insertedData["hiv_result"] = $data["hiv_result"];
            $insertedData["art_rx"] = $data["art_rx"];
            $insertedData["cpt_rx"] = $data["cpt_rx"];

            if ($insertedData["art_rx"] == 2) {
                $insertedData["art_rx_date"] = $data["art_rx_date"];
            } else {
                $insertedData["art_rx_date"] = NULL;
            }

            if ($insertedData["cpt_rx"] == 2) {
                $insertedData["cpt_rx_date"] = $data["cpt_rx_date"];
            } else {
                $insertedData["cpt_rx_date"] = NULL;
            }
        } else {
            $insertedData["hiv_date"] = NULL;
            $insertedData["hiv_result"] = NULL;
            $insertedData["art_rx"] = NULL;
            $insertedData["cpt_rx"] = NULL;
        }
        
        if(isset($data["mdrtb_reg_no"]))
        {
             $insertedData["cpt_rx_date"] = $data["cpt_rx_date"];
        }
       
        $this->model->update($insertedData);  
        $presumptive_model = \App\Models\Presumptive::where("patient_id",$data["id"])
                                ->update( ['index_case_no'=>  $data["mdrtb_reg_no"],'index_case_year'=>  $data["mdrtb_reg_year"],'index_case_monopoly'=>  $data["mdrtb_monopoly"]]);

        return $model;
    }

    public function updateFinishInformation($data)
    {
        $model = $this->getEach("id", $data["id"]);
        $insertedData = [
            'treatment_finish' => $data["treatment_finish"],
            'finished_date' => $data["finished_date"],
            'final_outcome' => $data["final_outcome"],
            'final_outcome_date' => $data["final_outcome_date"],
            'change_finished_date' => \Carbon\Carbon::now()
        ];
        
        
         if ($insertedData["final_outcome"] == 3) {
             $insertedData["reason_for_lost"]=null;
              $insertedData["cause_of_death"]=$data['cause_of_death']?$data['cause_of_death']:null;
         }
         
         if ($insertedData["final_outcome"] == 4) {
             $insertedData["cause_of_death"]=null;
              $insertedData["reason_for_lost"]=$data['reason_for_lost']?$data['reason_for_lost']:null;
         }
         
        //if ($insertedData["final_outcome"] == 4) {
        $insertedData["issue_date"] = $data["issue_date"];
        // } else {
        //     $insertedData["issue_date"] = NULL;
        // }

        $this->model->update($insertedData);

        return $model;
    }

    public function checkEnrollInfoError()
    {

        $model = \App\Models\Patient::where("mdrtb_reg_no", request("mdrtb_reg_no"))
                                    ->where("mdrtb_reg_year", request("mdrtb_reg_year"))
                                    ->where("mdrtb_monopoly", request("mdrtb_monopoly"))
                                    ->where("township_id", request()->user()->township_id)->where("id", "!=", request("id"))->first();



        if ($model) {
            return [
                "success" => false,
                "message" => "MDRTB Register Number is already existed"
            ];
        } else {
            return [
                "success" => true
            ];
        }
    }
}
