<?php

namespace App\Service\PA;
use Illuminate\Support\Facades\DB;

class HomeVisit extends CustomClassContainer
{

    function __construct()
    {
        parent::__construct(new \App\Models\HomeVisitActivity());
    }

    public function save($data)
    {
      
        $insertedData = [
            'type' => $data['type'],
            'patient_id' => $data['patient_id']!=null?$data['patient_id']:null,
            'outside_township' => $data['outside_tsp']!=null?$data['outside_tsp']:null,
            'mdrtb_code' => (int)$data["mdrtb_code"],
            'mdrtb_year' => (int) $data["mdrtb_year"],
            'monopoly'=>$data["monopoly"],
            'date' => $data['date'],
            'se_checklist' => json_encode($data['se_checklist']),
            'infection_control' => json_encode($data['infection_control']),
            'month' => $data['month'],
            'year' => $data['year'],
            'lived_patients_no'=>$data['lived_patients_no'],
            'infection_remark'=>$data['infection_remark'],
             'sideeffect_remark'=> $data['sideeffect_remark'],
            "township_id" => request()->user()->township_id,
            "patient_township_id"=>$data['patient_township_id'],
            'treatment_start_date' => $data['treatment_start_date'],
            'current_regimen' =>null,
            'current_month' => $data['current_month'],
            'smear_result' => $data['smear_result'],
            'smear_follow_up_month' => $data['smear_follow_up_month'],
            'culture_result' => $data['culture_result'],
            'culture_follow_up_month' => $data['culture_follow_up_month'],
            'body_weight' => $data['body_weight'],
            'modifications' => json_encode($data['modifications']),
            'is_alert' => $data['is_alert'],
        ];


        $createdRecord = $this->model->create($insertedData);
    
        $createdId = $createdRecord->id;
        
         //update patient latest homevisit to get culture result
        
         $updated = DB::update('UPDATE patients SET home_visit_id = ? WHERE id = ?', [$createdId,$data['patient_id']]);
        

        return $createdRecord;
        
    }



    public function withColumn()
    {
        $this->model = $this->model->with([
            "township",
        ]);
    }

    public function getEach($column = null, $value = null)
    {
        $this->withColumn();
        return $this->model->where($column,$value)->first();
    }


    public function getAll($data)
    {
        if($data['month']<'13' || $data['month']<13){
            $this->withColumn();
            $this->filter(["month", "year", "id","is_alert"], $data);
        }
        if($data['month']=='13' || $data['month']==13)
        {
             $this->withColumn();
             $this->filter(["year", "id","is_alert"], $data);
             $this->model->whereBetween('month',[1,3]);
        }
        if($data['month']=='14' || $data['month']==14)
        {
             $this->withColumn();
             $this->filter(["year", "id","is_alert"], $data);
             $this->model->whereBetween('month',[4,6]);
        }
        if($data['month']=='15' || $data['month']==15)
        {
             $this->withColumn();
             $this->filter(["year", "id","is_alert"], $data);
             $this->model->whereBetween('month',[7,9]);
        }
        if($data['month']=='16' || $data['month']==16)
        {
             $this->withColumn();
             $this->filter(["year", "id","is_alert"], $data);
             $this->model->whereBetween('month',[10,12]);
        }
        
        
        return $this->model
            ->where("township_id", request()->user()->township_id)
            ->get();
    }
    
    public function getPowerBi($data)
    {
        $this->withColumn();
        $this->filter(["month", "year", "id","is_alert"], $data);
        return $this->model->get();
        
    }
  

    public function getUncompletedList($data)
    {
        return $this->model->findMany(json_decode($data));
    }


    public function update($data)
    {
        $model = $this->getEach("id", $data["id"]);
        $insertedData = [
            'type' => $data['type'],
            'patient_id' => $data['patient_id'],
           'mdrtb_code' => $data["mdrtb_code"],
            'mdrtb_year' => $data["mdrtb_year"],
            'monopoly'=>$data["monopoly"],
            'date' => $data['date'],
            'outside_township' => $data['outside_tsp']!=null?$data['outside_tsp']:null,
            'lived_patients_no'=>$data['lived_patients_no'],
            'se_checklist' => json_encode($data['se_checklist']),
            'infection_control' => json_encode($data['infection_control']),
             'infection_remark'=>$data['infection_remark'],
            'sideeffect_remark'=> $data['sideeffect_remark'],
            'treatment_start_date' => $data['treatment_startdate'],
            'current_regimen' => $data['current_regimen']?$data['current_regimen']:null,
            'current_month' => $data['current_month'],
            'smear_result' => $data['smear_result'],
            'smear_follow_up_month' => $data['smear_follow_up_month'],
            'culture_result' => $data['culture_result'],
            'culture_follow_up_month' => $data['culture_follow_up_month'],
            'body_weight' => $data['body_weight'],
            'modifications' =>json_encode($data['modifications']),
            'is_alert' => $data['is_alert'],

        ];
        return $model->update($insertedData);
    }

    


    public function delete($id)
    {
        $model = $this->getEach("id", $id);
        $model->delete();
        return true;
    }
}
