<?php

namespace App\Service\PA;
use Illuminate\Support\Facades\Auth;
class He extends CustomClassContainer
{

    function __construct()
    {
        parent::__construct(new \App\Models\HeActivity());
    }

    public function save($data)
    {
        $insertedData = [
            "date" => $data["date"],
            "remark" => $data["remark"],
            "place" => $data["place"],
            "month" => $data["month"],
            "year" => $data["year"],
            "type" => $data["type"],
            "screening_person"=>$data["screening_person"],
            "township_id" => request()->user()->township_id,
            "supporting_township_id"=>$data["supporting_township_id"],
            "refer_male"=>$data["refer_male"]==null?0:$data["refer_male"],
            "refer_female"=>$data["refer_female"]==null?0:$data["refer_female"],
        ];
        
        if($insertedData["screening_person"]==1)
        {
             $insertedData["volunteer_id"] = $data["volunteer_id"];
        }
        
        if ($insertedData["type"] == 1) {
            $insertedData["n_o_attendence_male"]=$data["n_o_attendence_male"];
            $insertedData["n_o_attendence_female"]=$data["n_o_attendence_female"];
         }
         
        if ($insertedData["type"] == 2) {
            $insertedData["index_case_no"] = $data["index_case_no"];
            $insertedData["index_case_year"] = $data["index_case_year"];
             $insertedData["monopoly"] = $data["index_case_monopoly"];
            $insertedData["index_case_initial"] = $data["index_case_initial"];
            $insertedData["n_o_household_male"]=$data["n_o_household_male"];
            $insertedData["n_o_household_female"]=$data["n_o_household_female"];
            $insertedData["n_o_closecontact_male"]=$data["n_o_closecontact_male"];
            $insertedData["n_o_closecontact_female"]=$data["n_o_closecontact_female"];
        }
        
        $result = $this->model->create($insertedData);
        
        // foreach ($data["symptoms"] as $item) {
        //     $HeActivitySymptomModel = new \App\Models\HeActivitySymptom;
        //     $HeActivitySymptomModel->he_activity_id =  $result->id;
        //     $HeActivitySymptomModel->symptom_id =  $item;
        //     $HeActivitySymptomModel->save();
        // }

         

        return $result;
    }


    public function withColumn()
    {
         $this->model = $this->model->with([
            "township" => function ($query) {
                $query->with([
                    "township_group" ]);
            }, "volunteer","symptoms"
        ]);
    }

    public function getEach($column = null, $value = null)
    {
        $this->withColumn();
        return $this->model->where($column, $value)->first();
    }


    public function getAll($data)
    {
        if($data['month']<'13' || $data['month']<13){
            $this->withColumn();
            $this->filter(["month", "year", "id"], $data);
        }
        if($data['month']=='13' || $data['month']==13)
        {
             $this->withColumn();
             $this->filter(["year", "id","is_alert"], $data);
             $this->model->whereBetween('month',[1,3]);
        }
        if($data['month']=='14' || $data['month']==14)
        {
             $this->withColumn();
             $this->filter(["year", "id","is_alert"], $data);
             $this->model->whereBetween('month',[4,6]);
        }
        if($data['month']=='15' || $data['month']==15)
        {
             $this->withColumn();
             $this->filter(["year", "id","is_alert"], $data);
             $this->model->whereBetween('month',[7,9]);
        }
        if($data['month']=='16' || $data['month']==16)
        {
             $this->withColumn();
             $this->filter(["year", "id","is_alert"], $data);
             $this->model->whereBetween('month',[10,12]);
        }
       
       if(isset($data['township_id']))
       {
           if($data['township_id']=='township_group')
           {
               $township_group_id=$data['township_group_id'];
              return $this->model->whereHas("township",function($query)use($township_group_id){
                    $query->where("township_group_id",$township_group_id);
                })->get();
           }
            return $this->model
            ->where("township_id",$data['township_id'])
            ->get();
            
            if($data['township_id']=='undefined')
           {
                 return $this->model
                ->get();
           }
       }
       if(isset( request()->user()->township_id))
       {
             return $this->model
            ->where("township_id", request()->user()->township_id)
            ->get();
       }
       
         return $this->model
                ->get();
       
       
    }
    
    public function getAllDashboard($data)
    {
        if($data['month']<'13' || $data['month']<13){
            $this->withColumn();
            $this->filter(["month", "year", "id"], $data);
        }
        if($data['month']=='13' || $data['month']==13)
        {
             $this->withColumn();
             $this->filter(["year", "id","is_alert"], $data);
             $this->model->whereBetween('month',[1,3]);
        }
        if($data['month']=='14' || $data['month']==14)
        {
             $this->withColumn();
             $this->filter(["year", "id","is_alert"], $data);
             $this->model->whereBetween('month',[4,6]);
        }
        if($data['month']=='15' || $data['month']==15)
        {
             $this->withColumn();
             $this->filter(["year", "id","is_alert"], $data);
             $this->model->whereBetween('month',[7,9]);
        }
        if($data['month']=='16' || $data['month']==16)
        {
             $this->withColumn();
             $this->filter(["year", "id","is_alert"], $data);
             $this->model->whereBetween('month',[10,12]);
        }
       
       if(($data['township_id'])=='undefined')
       {
          
            return $this->model
                ->get();
            
       }
       else{
               return $this->model
            ->where("township_id",$data['township_id'])
            ->get();
       }
       
       
       
       
    }
    
     public function getPowerBi($data)
    {
        $this->withColumn();
        $this->filter(["month", "year", "id"], $data);
         return $this->model->get();
    }

    public function getUncompletedList($data)
    {
        return $this->model->findMany(json_decode($data));
    }


    public function update($data)
    {
        $model = $this->getEach("id", $data["id"]);

        $insertedData = [
            "date" => $data["date"],
            "remark" => $data["remark"],
            "place" => $data["place"],
            "type" => $data["type"],
            "screening_person"=>$data["screening_person"],
             "supporting_township_id"=>$data["supporting_township_id"],
            "refer_male"=>$data["refer_male"],
            "refer_female"=>$data["refer_female"],
           
        ];

         if($insertedData["screening_person"]==1)
            {
                 $insertedData["volunteer_id"] = $data["volunteer_id"];
            }
         if ($insertedData["type"] == 1) {
            $insertedData["n_o_attendence_male"]=$data["n_o_attendence_male"];
            $insertedData["n_o_attendence_female"]=$data["n_o_attendence_female"];
            
            $insertedData["n_o_household_male"]=0;
            $insertedData["n_o_household_male"]=0;
            $insertedData["n_o_closecontact_male"]=0;
            $insertedData["n_o_closecontact_female"]=0;
            
            $insertedData["index_case_no"] = NULL;
            $insertedData["index_case_year"] = NULL;
             $insertedData["monopoly"] = 1;
            $insertedData["index_case_initial"] = NULL;
         }
         
        if ($insertedData["type"] == 2) {
            $insertedData["index_case_no"] = $data["index_case_no"];
            $insertedData["index_case_year"] = $data["index_case_year"];
            $insertedData["index_case_initial"] = $data["index_case_initial"];
             $insertedData["monopoly"] = $data["index_case_monopoly"];
             
             $insertedData["n_o_attendence_male"]=0;
            $insertedData["n_o_attendence_female"]=0;
            
            $insertedData["n_o_household_male"]=$data["n_o_household_male"];
            $insertedData["n_o_household_female"]=$data["n_o_household_female"];
            $insertedData["n_o_closecontact_male"]=$data["n_o_closecontact_male"];
            $insertedData["n_o_closecontact_female"]=$data["n_o_closecontact_female"];
        } 
        
        \App\Models\HeActivitySymptom::where("he_activity_id", $data["id"])->delete();
        
        // foreach ($data["symptoms"] as $item) {
        //     $HeActivitySymptomModel = new \App\Models\HeActivitySymptom;
        //     $HeActivitySymptomModel->he_activity_id =  $data["id"];
        //     $HeActivitySymptomModel->symptom_id =  $item;
        //     $HeActivitySymptomModel->save();
        // }


        return $model->update($insertedData);
    }



    public function delete($id)
    {
        $model = $this->getEach("id",$id);
        $model->delete();
        return true;
    }
}
