<?php

namespace App\Service\PA;

class FormSeven
{

    public function get()
    {
        $enrollLists = \App\Models\EnrollSupport::whereHas("patient", function ($query) {
            $query->where("township_id", request()->user()->township_id)->where("status",1);
        })->with("patient")->where("status", 1)->where("support", 2);

        if (request("startDate") && request("endDate")) {
            $enrollLists = $enrollLists->whereBetween("date", [request("startDate"), request("endDate")]);
        }

        $enrollLists = $enrollLists->orderBy("date")->orderBy("repay")->get()->toArray();

        $preEnrollLists = \App\Models\PreEnrollSupport::whereHas("patient", function ($query) {
            $query->where("township_id", request()->user()->township_id)->where("status",1);
        })->with("patient")->where("status", 1)->where("support", 2);
        
        if (request("startDate") && request("endDate")) {
            $preEnrollLists = $preEnrollLists->whereBetween("date", [request("startDate"), request("endDate")]);
        }
        $preEnrollLists = $preEnrollLists->orderBy("date")->orderBy("repay")->get()->toArray();

        $mergeData = array_merge($enrollLists, $preEnrollLists);
        usort($mergeData, function ($a1, $a2) {
            $v1 = strtotime($a1['date']);
            $v2 = strtotime($a2['date']);
            return $v1 - $v2; // $v2 - $v1 to reverse direction
        });

        if (count($mergeData) == 0) {
            return [];
        }

        $groupArray = [];
        $groupPreArray = [];
        $tempOne = "";
        $tempTypeOne = "";
         foreach ($mergeData as $index => $data) {
            if ($data["type_info"] == "PREENROLL") {
                $data["final_remark"] = "Pre-enroll";
                if ($data["month_type"] == 1) $data["final_remark"] .= " Month 1 ";
                else if ($data["month_type"] == 2) $data["final_remark"] .= " Month 2 ";
               
                $data["payment"] = 60000;
             } 
            else if ($data["type_info"] == "ENROLL") {
                // if ($data["repay"] == 2) {
                //     $data["final_remark"] = "Reimbursement for Enroll" . $data["support_month"];
                // }
                $data["final_remark"] = "Enroll" . $data["support_month"];
                $data["payment"] = 110000;
            }
            if ($tempOne != $data["date"]) {
                $tempOne = $data["date"];
                $tempTypeOne = $data["type_info"];
                $groupArray[$data["date"]] = [];
                $groupPreArray[$data["date"]] = [];
                if($data["type_info"] == "PREENROLL"){
                    array_push($groupPreArray[$data["date"]], $data);
                }else{
                    array_push($groupArray[$data["date"]], $data);
                }
            } else {
                 if($data["type_info"] == "PREENROLL"){
                    array_push($groupPreArray[$data["date"]], $data);
                }else{
                    array_push($groupArray[$data["date"]], $data);
                }
                
            }
        }
        
        // var_dump($groupArray);
        
         $finalPreArray = [];
        foreach ($groupPreArray as $eachDateArray) {
            $tempOne = NULL;
            foreach ($eachDateArray as $item) {
                if ($tempOne == NULL) {
                    array_push($finalPreArray, $item);
                    $tempOne = $item;
                } else {
                    if ($item["patient_id"] != $tempOne["patient_id"]) {
                        array_push($finalPreArray, $item);
                        $tempOne = $item;
                    } else {
                        $lastIndexData = $finalPreArray[count($finalPreArray) - 1];
                        $lastIndexData["payment"] = $lastIndexData["payment"] + $item["payment"];
                        $lastIndexData["final_remark"] = "Pre-enroll month 1+2";
                        $finalPreArray[count($finalPreArray) - 1] = $lastIndexData;
                    }
                }
            }
        }
        

        $finalArray = [];
        foreach ($groupArray as $eachDateArray) {
            
            $tempOne = NULL;
            foreach ($eachDateArray as $item) {
                if ($tempOne == NULL) {
                    array_push($finalArray, $item);
                    $tempOne = $item;
                } else {
                    if ($item["patient_id"] != $tempOne["patient_id"]) {
                        array_push($finalArray, $item);
                        $tempOne = $item;
                    } else {
                        $lastIndexData = $finalArray[count($finalArray) - 1];
                        $lastIndexData["payment"] = $lastIndexData["payment"] + $item["payment"];
                        $lastIndexData["final_remark"] = "Reimbursement Enroll";
                        $lastIndexData["final_remark"] .= $lastIndexData["support_month"] . ',' . $item["support_month"];
                        $finalArray[count($finalArray) - 1] = $lastIndexData;
                       
                    }
                }
            }
        }
        $apiArray = array_merge($finalArray,$finalPreArray);

        return $apiArray;
    }
}
