<?php

namespace App\Service\PA;

class FamilyMember extends CustomClassContainer
{

    function __construct()
    {
        parent::__construct(new \App\Models\Presumptive());
    }

    public function save($data)
    {

        $patient = \App\Models\Patient::where("id", $data["patient_id"])->first();

        $insertedData = [
            "name" => $data["name"],
            "sex" => $data["sex"],
            "age" => $data["age"],
            
             "reason" => $data["reason"],
            "eligible" => $data["eligible"],
            
            "patient_id" => $data["patient_id"],
            "township_id" => $patient->township->id,

            "index_case_no" => $patient->mdrtb_reg_no,
            "index_case_year" => $patient->mdrtb_reg_year,
            "index_case_initial" => $patient->mdrtb_reg_initial,

            "township_id" => request()->user()->township_id,
            "case_found_at" => \App\Models\CaseFoundAt::where("name", "DRTB CT")->first()->id,
            "relationship" => 1,
            "confirm" => 0
        ];
        return $this->model->create($insertedData);
        
    }

    public function getEach($column = null, $value = null)
    {
        return $this->model->where($column, $value)->first();
    }


    public function getAll($data)
    {
        $this->filter(["patient_id"], $data);
        return $this->model->where("status", 1)->get();
    }

    public function update($data)
    {
        $model = $this->getEach("id", $data["id"]);
        return $model->update([
           "name" => $data["name"],
            "sex" => $data["sex"],
            "age" => $data["age"],
            "eligible" => $data["eligible"],
            "reason" => $data["eligible"]=='2'?null:$data["reason"],
        ]);
    }

    public function delete($id)
    {
        $model = $this->getEach("id", $id);
        $model->status = 0;
        $model->update();
        return true;
    }
}
