<?php

namespace App\Service\PA;

class DOTSVolunteer extends CustomClassContainer
{

    function __construct()
    {
        parent::__construct(new \App\Models\DotsVolunteerActivity());
    }

    public function withColumn()
    {
        $this->model = $this->model->with([
            "dots_patient", "volunteer"
        ]);
    }

    public function getEach($column = null, $value = null)
    {
        $this->withColumn();
        return $this->model->where($column, $value)->first();
    }


    public function getAll($data)
    {
        $this->withColumn();
        $this->filter(["dots_patient_id"], $data);
        return $this->model->get();
    }

    public function update($data)
    {
        $model = $this->getEach("id", $data["id"]);
        $insertedData = [
            "date" => $data["date"],
            "volunteer_id" => $data["volunteer_id"],
            "dots_app_status" => $data["dots_app_status"],
            "dots_patient_id" => $data["dots_patient_id"],
        ];

        $patient = \App\Models\DOTSPatient::where("id", $data["dots_patient_id"])->first();
        $patient->volunteer_id = $data["volunteer_id"];
        $patient->dots_app_status = $data["dots_app_status"];
        $patient->update();


        return $model->update($insertedData);
    }

    public function save($data)
    {
        $insertedData = $this->model->create([
            "date" => $data["date"],
            "volunteer_id" => $data["volunteer_id"],
            "dots_app_status" => $data["dots_app_status"],
            "dots_patient_id" => $data["dots_patient_id"],
        ]);

        $patient = \App\Models\DOTSPatient::where("id", $data["dots_patient_id"])->first();
        $patient->volunteer_id = $data["volunteer_id"];
        $patient->dots_app_status = $data["dots_app_status"];
        $patient->update();


        return $insertedData;
    }

    public function delete($id)
    {
        $model = $this->getEach("id", $id);
        $model->delete();
        return true;
    }
}
