<?php

namespace App\Service\PA;

class DOTSPatient extends CustomClassContainer
{

    function __construct()
    {
        parent::__construct(new \App\Models\DOTSPatient());
    }

    public function save($data)
    {
        $insertedData = [
            'patient_id' => $data['patient_id'],
            'volunteer_id' => $data['volunteer_id'],
            'phone' => $data['phone'],
            'body_weight' => $data['body_weight'],
            'dots_startdate' => $data['dots_startdate'],
            'dots_app_status' => $data['dots_app_status'],
        ];
        
         if(isset($data['supporting_township_id'])){
           $insertedData["supporting_township"] = $data['supporting_township_id'];
        }
        
        if(isset($data['dots_drugs'])){
             $insertedData['dots_drugs'] = json_encode($data['dots_drugs'],JSON_UNESCAPED_SLASHES);
        }

        $insertedData = $this->model->create($insertedData);

        $dotsActivityModel = new \App\Models\DotsMainActivity;
        $dotsActivityModel->create([
            "dots_patient_id" => $insertedData->id,
            "dots_startdate" => $data["dots_startdate"],
            'volunteer_id' => $data['volunteer_id'],
            'dots_app_status' => $data['dots_app_status'],
        ]);




        return $insertedData;
    }



    public function withColumn()
    {
        $this->model = $this->model->with([
            "patient" => function ($query) {
                $query->with(["mdrtbRegiments" => function ($query) {
                    $query->orderBy("created_at", "desc");
                }]);
            }, "volunteer"
        ]);
    }

    public function getEach($column = null, $value = null)
    {
        $this->withColumn();
        $result =  $this->model->where($column, $value)->first();
        
       $result['dots_drugs'] = json_decode($result['dots_drugs']);

        
        return $result;
    }


    public function getAll($data)
    {
        $this->withColumn();
        $this->filter(["patient_id", "current_status", "dots_app_status"], $data);

        $now = \Carbon\Carbon::now();
        if (isset($data["reported_status"])) {
            if ($data["reported_status"] == 2) {

                $this->model = $this->model->whereHas("dots_visit_report", function ($query) use ($now) {
                    $query->where("month", $now->month)->where("year", $now->year);
                });
            } else if ($data["reported_status"] == 1) {
                $this->model = $this->model->whereDoesntHave("dots_visit_report", function ($query) use ($now) {
                    $query->where("month", $now->month)->where("year", $now->year);
                });
            }
        }
        
        if (isset(request()->name)){
              $this->model = $this->model->whereHas("patient",function($query){
                      $query->where("name", "like", request("name") . "%");
              });
        }
        
        if (isset(request()->startDate) && isset(request()->endDate)){
              $this->model = $this->model->whereBetwen("dots_startdate",[request()->startDate,request()->endDate]);
        }
        
        if (isset(request()->month) && isset(request()->year)){
              $this->model = $this->model->whereMonth("dots_startdate", request("month"))->whereYear("dots_startdate", request("year"));
        }
        
        
        $this->model =$this->model
                        ->whereHas("patient", function ($query) {
                            $query->where("township_id", request()->user()->township_id)->where("status",1);
                        })->where("status",1);

        $supporting_result = \App\Models\DOTSPatient::
                            where("supporting_township",request()->user()->township_id)
                            ->with("patient","volunteer")->get();

         $supporting_result_count = \App\Models\DOTSPatient::
                            where("supporting_township",request()->user()->township_id)->count();
        
        $limit = 30;
        $page = 0;
        $total = $this->model->count()+$supporting_result_count;
        $page = (int)($total / $limit);
        if ($total % $limit != 0) {
            $page += 1;
        }
        $currentPage = request()->page ? request()->page : 1;
        $skipStart = 0;
        if ($currentPage > 1) {
            $skipStart = ($limit * ($currentPage - 1));
        }
        
       // $result=$this->model->skip($skipStart)->take($limit)->get();
        $result = $this->model->get();
        $final_result = $result->concat($supporting_result);
        
        return [
            "result" => $final_result,
            "total" => $total ,
            "page" => $page,
        ];
        
        
    }


    public function update($data)
    {
        $model = $this->getEach("id", $data["id"]);
        $insertedData = [
            'phone' => $data['phone'],
            'body_weight' => $data['body_weight'],
            'dots_drugs' => json_encode($data['dots_drugs'],JSON_UNESCAPED_SLASHES)
        ];
        return $model->update($insertedData);
    }



    public function delete($id)
    {
        $model = $this->getEach("id", $id);
        $model->delete();
        return true;
    }

    public function finishVisitDate()
    {
        $model = $this->getEach("id", request("dots_patient_id"));
        $model->dots_enddate = request("date");
        $model->current_status = 0;
        $model->update();

        $dotsActity = \App\Models\DotsMainActivity::where("dots_patient_id", request("dots_patient_id"))->orderBy("id", "desc")->first();
        $dotsActity->dots_enddate = request("date");
        $dotsActity->update();
    }

    public function getVisitDate()
    {
        $dotApp = \App\Models\DotsVisitDate::where("dots_patient_id", request("dots_patient_id"))->get();
        
         $innoApp = \App\Models\InnoDotsDate::where("dots_patient_id", request("dots_patient_id"))->get();
         
         $visitDates = $dotApp->concat($innoApp);
         
        return $visitDates;
    }
}
