<?php

namespace App\Service\PA;

class Couseling extends CustomClassContainer
{

    function __construct()
    {
        parent::__construct(new \App\Models\CounselingActivity());
    }

    public function save($data)
    {
        $insertedData = [
            'month' => $data["month"],
            'year' => $data["year"],
            'date' => $data["date"],
            'type' => $data["type"],
             'mdrtb_code' => $data["mdrtb_code"],
              'mdrtb_year' => $data["mdrtb_year"],
                'mdrtb_monopoly' => $data["mdrtb_monopoly"],
             'patient_id' => $data["patient_id"],
              'patient_township_id' => $data["patient_township_id"],
            'less_than_5_count' => $data["less_than_5_count"],
            'between_5_and_14_count' => $data["between_5_and_14_count"],
            'greate_than_15' => $data["greate_than_15"],
            "township_id" => request()->user()->township_id,
        ];


        $result = $this->model->create($insertedData);

        foreach ($data["topics"] as $item) {
            $topicModel = new \App\Models\CounselingActivityTopic;
            $topicModel->counseling_activity_id =  $result->id;
            $topicModel->topic_id =  $item;
            $topicModel->save();
        }


        return $result;
    }



    public function withColumn()
    {
        $this->model = $this->model->with([
            "township", "topics","patient"
        ]);
    }

    public function getEach($column = null, $value = null)
    {
        $this->withColumn();
        return $this->model->where($column, $value)->first();
    }


    public function getAll($data)
    {
        if($data['month']<'13' || $data['month']<13)
        {
            $this->withColumn();
            $this->filter(["month", "year", "id"], $data);
        }
        if($data['month']=='13' || $data['month']==13)
        {
             $this->withColumn();
             $this->filter(["year", "id","is_alert"], $data);
             $this->model->whereBetween('month',[1,3]);
        }
        if($data['month']=='14' || $data['month']==14)
        {
             $this->withColumn();
             $this->filter(["year", "id","is_alert"], $data);
             $this->model->whereBetween('month',[4,6]);
        }
        if($data['month']=='15' || $data['month']==15)
        {
             $this->withColumn();
             $this->filter(["year", "id","is_alert"], $data);
             $this->model->whereBetween('month',[7,9]);
        }
        if($data['month']=='16' || $data['month']==16)
        {
             $this->withColumn();
             $this->filter(["year", "id","is_alert"], $data);
             $this->model->whereBetween('month',[10,12]);
        }
        
        return $this->model
            ->where("township_id", request()->user()->township_id)
            ->get();
    }
    
     public function getPowerBi($data)
    {
        $this->withColumn();
        $this->filter(["month", "year", "id"], $data);
        return $this->model->get();
    }

    public function getUncompletedList($data)
    {
        return $this->model->findMany(json_decode($data));
    }


    public function update($data)
    {
        $model = $this->getEach("id", $data["id"]);

        $insertedData = [
            'date' => $data["date"],
            'type' => $data["type"],
              'mdrtb_code' => $data["mdrtb_code"],
              'mdrtb_year' => $data["mdrtb_year"],
              'mdrtb_monopoly' => $data["mdrtb_monopoly"],
            'less_than_5_count' => $data["less_than_5_count"],
            'between_5_and_14_count' => $data["between_5_and_14_count"],
            'greate_than_15' => $data["greate_than_15"],
             'patient_township_id' => $data["patient_township_id"],
        ];

        \App\Models\CounselingActivityTopic::where("counseling_activity_id", $data["id"])->delete();

        foreach ($data["topics"] as $item) {
            $topicModel = new \App\Models\CounselingActivityTopic;
            $topicModel->counseling_activity_id =  $data["id"];
            $topicModel->topic_id =  $item;
            $topicModel->save();
        }

        return $model->update($insertedData);
    }



    public function delete($id)
    {
        $model = $this->getEach("id", $id);
        $model->delete();
        return true;
    }
}
