<?php

namespace App\Service\EnrollApp;

class PreEnrollSupport extends CustomClassContainer
{

    function __construct()
    {
        parent::__construct(new \App\Models\PreEnrollSupport());
    }

   public function save($data)
    {
    foreach ($data as $item) {
        $model = \App\Models\PreEnrollSupport::where([
            "date"=> $item["date"],
            "patient_id"=> $item["patient_id"],
            "support_month"=> $item["support_month"],
            "support_year"=> $item["support_year"],
        ])->first();

        $insertedData = [
            "nominated" => $item["nominated"],
            "support_month" => $item["support_month"],
            "support_year" => $item["support_year"],
            "status" => $item["status"],
            "date" => $item["date"],
            "nominated_year" => $item["nominated_year"],
            "nominated_month" => $item["nominated_month"],
            "month_type" => $item["month_type"],
        ];

        if ($item["nominated"] == 2 && $item["support"] == 2) {
            $insertedData["support"] = $item["support"];
            $insertedData["type"] = $item["type"];
            
            // if (!is_null($item["signature"]) && $item["signature"] != "null" && $insertedData["type"] == 1) {
            //     $insertedData["signature"] = $item["signature"];
            // } 
            
            if  (!is_null($item["signature"]) && $item["signature"] != "null" && $insertedData["type"] == 1)  {

                $base64Image = $item["signature"];

                $data = substr($base64Image, strpos($base64Image, ',') + 1);

                // Convert Base64 to binary data
                $imageData = base64_decode($data);

                $imageName = uniqid() . '.png';

                // Save the image
                
                file_put_contents(storage_path('app/public/patients/enrolls/supports' . $imageName), $imageData);
                
                $insertedData["signature"] = $imageName;

            }

        }

        if ($model) {
            $model->update($insertedData);
        } else {
            $insertedData["patient_id"] = $item["patient_id"];
            $model = \App\Models\PreEnrollSupport::create($insertedData);
        }
    }
}

    public function checkError()
    {
        $patient = \App\Models\Patient::where("id", request("patient_id"))->first();
        $yesCount = $this->model->where("patient_id", request()->patient_id)->where("support", 2)->where("status", 1)->count();
        if ($yesCount >= 2) {
            return [
                "success" => false,
                "message" => "Support have been given two times"
            ];
        }

        $yesCount = $this->model->where([
            "support_month" => request()->support_month,
            "support_year" => request()->support_year,
            "patient_id" => request()->patient_id,
            "status" => 1,
            "support" => 2,
        ])->count();
        if ($yesCount > 0)
            return [
                "success" => false,
                "message" => "Support have been for this month"
            ];



        if (request("support") == 2) {


            $date1 = strtotime(request("support_year") . "-" . request("support_month") . "-01");
            $date2 = strtotime(request("date"));

            if ($date2 < $date1) {
                return [
                    "success" => false,
                    "message" => "Support date should be larger than support month and year"
                ];
            }
        }

        if (request("support") == 2) {
            if ($patient->finished_date) {
                $date1 = strtotime($patient->finished_date);
                $date2 = strtotime(request("support_year") . "-" . request("support_month") . "-01");
                if ($date2 > $date1) {
                    return [
                        "success" => false,
                        "message" => "Date should not be greater than Finished Date "
                    ];
                }
            }
        }

        if (request("month_type") != 3) {
            $yesCount = \App\Models\PreEnrollSupport::where("patient_id", request("patient_id"))->where("support", 2)->where("month_type", 3)->count();
            if ($yesCount > 0) {
                return [
                    "success" => false,
                    "message" => "Month 1+2 have been given"
                ];
            }

            $yesCount = \App\Models\PreEnrollSupport::where("patient_id", request("patient_id"))->where("support", 2)->where("month_type", request("month_type"))->count();
            if ($yesCount > 0) {
                return [
                    "success" => false,
                    "message" => "Support have been given to that month type"
                ];
            }
        } else {
            $yesCount = \App\Models\PreEnrollSupport::where("patient_id", request("patient_id"))->where("support", 2)->where("month_type", request("month_type"))->count();
            if ($yesCount > 2) {
                return [
                    "success" => false,
                    "message" => "Support have been given to that month type"
                ];
            }
            $yesCount = \App\Models\PreEnrollSupport::where("patient_id", request("patient_id"))->where("support", 2)->whereIn("month_type", [1, 2])->count();
            if ($yesCount > 0) {
                return [
                    "success" => false,
                    "message" => "Support have been given to another month type"
                ];
            }
        }

        if (request("month_type") == 2) {
            $yesCount = \App\Models\PreEnrollSupport::where("patient_id", request("patient_id"))->where("support", 2)->where("month_type", 1)->count();
            if ($yesCount == 0) {
                return [
                    "success" => false,
                    "message" => "Support have to be given to Month 1 first"
                ];
            }
        }

        if (request("support") == 2) {
            $yesCount = $this->model->where([
                "patient_id" => request("patient_id"),
                "status" => 1,
                "support" => 2,
                "date" => request("date"),
            ])->first();

            if ($yesCount) {
                if ($yesCount->type != request("type")) {
                    return [
                        "success" => false,
                        "message" => "Same payment channel should be used"
                    ];
                }
            }
        }

        $lastSupport = $this->model->where(["patient_id" => request("patient_id"), "status" => 1])->orderBy("id", "desc")->first();
       
        return [
            "success" => true
        ];
    }



}