<?php

namespace App\Service\EnrollApp;

use App\Service\Utils\FileService;
class EnrollSupport extends CustomClassContainer
{

    function __construct()
    {
        parent::__construct(new \App\Models\EnrollSupport());
    }

  public function save($data)
    {
        // $base64Image = request()->signature;

        // $sign = substr($base64Image, strpos($base64Image, ',') + 1);

        // // Convert Base64 to binary data
        // $imageData = base64_decode($sign);

        // $imageName = uniqid() . '.png';

        // // Save the image
        
        // file_put_contents(storage_path('app/public/patients/enrolls/testing/' . $imageName), $imageData);
        
        // $insertedData["signature"] = $imageName;
        
        // return $insertedData["signature"];
                
    foreach ($data as $item) {
        $model = \App\Models\EnrollSupport::where([
            "date"=> $item["date"],
            "patient_id"=> $item["patient_id"],
            "support_month"=> $item["support_month"],
            "support_year"=> $item["support_year"]
        ])->first();

        $insertedData = [
            "nominated" => $item["nominated"],
            "support_month" => $item["support_month"],
            "support_year" => $item["support_year"],
            "nominated_year" => $item["nominated_year"],
            "nominated_month" => $item["nominated_month"],
            "status" => $item["status"],
            "date" => $item["date"],
            "type"=>$item["type"],
            "support"=>$item["support"],
            
        ];

        if ($item["nominated"] == 2 && $item["support"] == 2) {
            $insertedData["support"] = $item["support"];
            $insertedData["type"] = $item["type"];
            
            //   if ($insertedData["type"] == 1) {
            //         $signature = FileService::save($item["signature"], "patients/enrolls/supports");
            //         $insertedData["signature"] = $signature;
            //     }
                
            if ($insertedData["type"] == 1)  {

                $base64Image = $item["signature"];

                $data = substr($base64Image, strpos($base64Image, ',') + 1);

                // Convert Base64 to binary data
                $imageData = base64_decode($data);

                $imageName = uniqid() . '.png';

                // Save the image
                
                file_put_contents(storage_path('app/public/patients/enrolls/testing' . $imageName), $imageData);
                
                $insertedData["signature"] = $imageName;

            }
            
            // if (!is_null($item["signature"]) && $item["signature"] != "null" && $insertedData["type"] == 1) {
            //     $insertedData["signature"] = $item["signature"];
            // } 
            
            if ($insertedData["type"] != 1) {
                    $insertedData["signature"] = null;
                }

        }
        
        if ($model) {
            $model->update($insertedData);
        } else {
            $insertedData["patient_id"] = $item["patient_id"];
            $model = \App\Models\EnrollSupport::create($insertedData);
        }
    }
}

    public function checkError()
    {
        $patient = \App\Models\Patient::where("id", request("patient_id"))->first();
        $yesCount = $this->model->where([
            "support_month" => request()->support_month,
            "support_year" => request()->support_year,
            "patient_id" => request()->patient_id,
            "status" => 1,
            "support" => 2,
        ])->count();
        if ($yesCount > 0)
            return [
                "success" => false,
                "message" => "Support have been for this month"
            ];


        $date1 = strtotime($patient->treatment_startdate);
        $date2 = strtotime(request("support_year") . "-" . request("support_month") . "-31");
        if ($date2 < $date1) {
            return [
                "success" => false,
                "message" => "Support month and year should be larger than treatment startdate (" . $patient->treatment_startdate . ")"
            ];
        }

        if (request("support") == 2) {

            $date1 = strtotime($patient->treatment_startdate);
            $date2 = strtotime(request("date"));
            if ($date2 < $date1) {
                return [
                    "success" => false,
                    "message" => "Support date should be larger than treatment startdate (" . $patient->treatment_startdate . ")"
                ];
            }


            $date1 = strtotime(request("support_year") . "-" . request("support_month") . "-01");
            $date2 = strtotime(request("date"));

            if ($date2 < $date1) {
                return [
                    "success" => false,
                    "message" => "Support date should be larger than support month and year"
                ];
            }
        }

        if (request("support") == 2) {
            $yesCount = $this->model->where([
                "patient_id" => request()->patient_id,
                "status" => 1,
                "support" => 2,
                "date" => request("date"),
            ])->first();

            if ($yesCount) {
                if ($yesCount->type != request("type")) {
                    return [
                        "success" => false,
                        "message" => "Same payment channel should be used"
                    ];
                }
            }
        }


        if ($patient->finished_date) {
            $date1 = strtotime($patient->finished_date);
            $date2 = strtotime(request("support_year") . "-" . request("support_month") . "-01");
            if ($date2 > $date1) {
                return [
                    "success" => false,
                    "message" => "Date should not be greater than Finished Date "
                ];
            }
        }

        $lastSupport = $this->model->where(["patient_id" => request("patient_id"), "status" => 1])->orderBy("date", "desc")->orderBy("created_at", "desc")->first();

        return [
            "success" => true
        ];
    }

}