<?php

namespace App\Service\EnrollApp;

class EnrollPatient extends CustomClassContainer
{

    function __construct()
    {
        parent::__construct(new \App\Models\Patient());
    }
    
     public function withColumn()
    {

        $withColumns = [];

            $withColumns["enroll_supports"] = function ($query) {
                $query->where("status", 1)->orderBy("support_month")->orderBy("support_year");
            };

            $withColumns["pre_enroll_supports"] = function ($query) {
                $query->where("status", 1)->orderBy("support_month")->orderBy("support_year");
            };

        $this->model = $this->model->with($withColumns);
    }


    public function getAll()
    {   
        $this->withColumn();
        $result = $this->model->where("status", 1)
                             ->where("township_id", request()->user()->township_id)
                             ->where("final_outcome",'=',null)
                             ->orderBy('created_at','DESC')
                             ->get();
        return $result;
        
        // ->where("treatment_startdate","!=",null)
        // ->where("pre_enroll", 1)
    }
   
   
}
