<?php

namespace App\Service\DotsApp;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Mail;
use App\Mail\SendMail;
use Carbon\Carbon;

class DotsVisitDate extends CustomClassContainer
{
    function __construct()
    {
        parent::__construct(new \App\Models\DotsVisitDate);
    }

    public function getAll()
    {
        return $this->model::whereHas("dots_patient", function ($query) {
            $query->where("volunteer_id", request()->user()->id);
        })->where("volunteer_id", request()->user()->id)
          ->whereBetween("date", [
                            Carbon::now()->subMonths(6), 
                            Carbon::now()               
                        ])->get();
    }


    public function saveAll($visitdates)
    {
        
        foreach ($visitdates as $item) {
            
            //$model = \App\Models\DOTSVisitDate::where("date", $item->date)->where("dots_patient_id", $item->dots_patient_id)->first();
            
            $model = \App\Models\DOTSVisitDate::where("date",$item->date)
                                                ->where("dots_patient_id",$item->dots_patient_id)
                                                ->with([
                                                    "dots_patient.patient",
                                                    "volunteer"
                                                    ])
                                                ->with([
                                                    "dots_patient" => function ($query) {
                                                        $query->select('id','patient_id','volunteer_id'); 
                                                    },
                                                    "dots_patient.patient" => function ($query) {
                                                        $query->select('id', 'name','township_id','mdrtb_reg_no','mdrtb_reg_year','finished_date','change_finished_date'); 
                                                    },
                                                    "volunteer" => function ($query) {
                                                        $query->select('id', 'name'); 
                                                    }
                                                ])
                                                ->first();
            if ($model) {
                $model->date = $item->date;
                $model->status = $item->status;

                $model->low_side_effect = $item->lowSideEffect;
                $model->high_side_effect = $item->highSideEffect;
                $model->duration = $item->duration;
                $model->signature = $item->signature;
                $model->calling_time = $item->callingTime;
                $model->type = $item->type;
                $model->volunteer_id = request()->user()->id;
                $model->update();
            } else {
                $model = new \App\Models\DOTSVisitDate;
                $model->date = $item->date;
                $model->status = $item->status;
                $model->dots_patient_id = $item->dots_patient_id;
                $model->low_side_effect = $item->lowSideEffect;
                $model->high_side_effect = $item->highSideEffect;
                $model->duration = $item->duration;
                $model->signature = $item->signature;
                $model->calling_time = $item->callingTime;
                $model->type = $item->type;
                $model->volunteer_id = request()->user()->id;
                $model->save();
            }
            
                //get low side effect
                $code=$model->low_side_effect;
                $array = explode(',', $code);
              
                $low_side_effect = \App\Models\LowSideEffect::whereIn('id', $array)
                                  ->pluck('eng_name')
                                ->toArray();
                                
                //check high side effect 3 or 4
                 $high_side_effect= $model->high_side_effect;
                 $township_id=$model->dots_patient->patient->township_id;
                
                $check_side_effect = Str::contains($high_side_effect,'3') || Str::contains($high_side_effect,'4')?'true':'false';
                
                //change alert status in dots_patients_table
                 if($check_side_effect=='true'){
                     $dots_patient = \App\Models\DOTSPatient::find($item->dots_patient_id);
                     
                     //$patient_id=$dots_patient->patient_id;
                     
                     $dots_patient->app_refer_status=1;
                     $dots_patient->update();
                 }
                 
                //send outlook mail
                // if($check_side_effect=='true')
                // {
                //     $contain_referred = Str::contains($high_side_effect,'3') ?'true':'false';
                //     $contain_immediate = Str::contains($high_side_effect,'4') ?'true':'false';
                    
                //      $data=[];
                //         if($contain_immediate=='true')
                //          {
                //               $data['side_effect'] = "immediate referred";
                             
                //          }elseif($contain_referred=='true')
                //          {
                //               $data['side_effect'] = "referred";
                //          }
                         
                //          $data['date'] = $model->date;
                //          $data['pt_name']= $model->dots_patient->patient->name;
                //          $data['vol_name']= $model->dots_patient->volunteer->name;
                //          $data['low_side_effect']=implode(', ', $low_side_effect);
                 
                //     $pas= \App\Models\PA::where("township_id", $township_id)->select('id','mail')->get();
                
                //     foreach ($pas as $key => $pa) {
                //         if($pa->mail)
                //         {
                //         try {
                //                  Mail::to($pa->mail)->send(new SendMail($data));
                //             } catch (\Exception $e) {
                //                 // Handle the exception, e.g., log the error or continue with the next iteration
                //                 \Log::error("Failed to send email to {$pa->mail}: " . $e->getMessage());
                //             }
                //         }
                       
                //     }
                // }
        }
        
    }
    
    public function test()
    {
             $model = \App\Models\DOTSVisitDate::where("date", '2022-11-04')
                                                ->where("dots_patient_id", 96)
                                                ->with([
                                                    "dots_patient.patient",
                                                    "volunteer"
                                                    ])
                                                ->with([
                                                    "dots_patient" => function ($query) {
                                                        $query->select('id','patient_id','volunteer_id'); 
                                                    },
                                                    "dots_patient.patient" => function ($query) {
                                                        $query->select('id', 'name','township_id','mdrtb_reg_no','mdrtb_reg_year','finished_date','change_finished_date'); 
                                                    },
                                                    "volunteer" => function ($query) {
                                                        $query->select('id', 'name'); 
                                                    }
                                                ])
                                                ->first();
            //get low side effect
            $code=$model->low_side_effect;
            $array = explode(',', $code);
          
            $low_side_effect = \App\Models\LowSideEffect::whereIn('id', $array)
                               ->pluck('eng_name')
                            ->toArray();
                                
            //check high side effect 3 or 4
             $high_side_effect= $model->high_side_effect;
             $township_id=$model->dots_patient->patient->township_id;
            
            $check_side_effect = Str::contains($high_side_effect,'3') || Str::contains($high_side_effect,'4')?'true':'false';
            
            if($check_side_effect=='true')
            {
                $contain_referred = Str::contains($high_side_effect,'3') ?'true':'false';
                $contain_immediate = Str::contains($high_side_effect,'4') ?'true':'false';
                 $data=[];
                    if($contain_immediate=='true')
                     {
                          $data['side_effect'] = "immediate referred";
                         
                     }elseif($contain_referred=='true')
                     {
                          $data['side_effect'] = "referred";
                     }
                     
                     $data['date'] = $model->date;
                     $data['pt_name']= $model->dots_patient->patient->name;
                     $data['vol_name']= $model->dots_patient->volunteer->name;
                     $data['low_side_effect']=implode(', ', $low_side_effect);
             
                $pas= \App\Models\PA::where("township_id", $township_id)->select('id','mail')->get();
            
                   
                Mail::to('thandar.tun@theunion.org')->send(new SendMail($data));
                 return "success";
                foreach ($pas as $key => $pa) {
                     return $pa->mail;
                   Mail::to($user->email)->send(new SendMail($data));
                }
            }
            
            
        }
       
}
