<?php

namespace App\Service\DotsApp;

use Illuminate\Support\Facades\Hash;

class DotsPatient extends CustomClassContainer
{
    function __construct()
    {
        parent::__construct(new \App\Models\DOTSPatient);
    }

    public function withColumn()
    {
        $this->model = $this->model->with([
            "patient" => function ($query) {
                  $query->with(["mdrtbRegiments" => function ($query) {
                    $query->orderBy("created_at", "desc");
                }]);
            }, "volunteer"
        ]);
    }

    public function getAll()
    {
        $this->withColumn();
        return $this->model->where([
            "volunteer_id" => request()->user()->id,
            "dots_app_status" => 2,
            "status" => 1,
        ])
        ->get();
    }
    
    public function test_getAll()
    {
        $this->withColumn();
        return $this->model->where([
            "volunteer_id" => request()->volunteer_id,
            "dots_app_status" => 2,
            "status" => 1,
        ])
        ->get();
    }
    
    
}
