<?php

namespace App\Service\Dashboard;

class VolunteerTraining extends CustomClassContainer
{

    function __construct()
    {
        parent::__construct(new \App\Models\VolunteerTraining());
    }


    public function withColumn()
    {
        $this->model = $this->model->with([]);
    }

    public function getEach($column = null, $value = null)
    {
        $this->withColumn();
        return $this->model->where($column, $value)->first();
    }


    public function getAll($data)
    {
        $this->withColumn();
        $this->filter(["date", "volunteer_id"], $data);
        return $this->model->where("status", 1)->get();
    }
}
