<?php

namespace App\Service\Dashboard;

class VolunteerReport
{
    public function get()
    {
        if (request("is_dots_report")) {
            return [
                "မိမိမှ ဆေးယဉ်ပါးတီဘီဆေး တိုက်ရိုက်တိုက်ကျွေးသူအရေအတွက်" => $this->getNo1(),
                "ဆေးကုသမှုပြီးစီးသည့် ဆေးယဉ်ပါးတီဘီလူနာအရေအတွက်" => $this->getNo2(),
            ];
        }

        return [
            "မိမိမှ ဆေးယဉ်ပါးတီဘီဆေး တိုက်ရိုက်တိုက်ကျွေးသူအရေအတွက်" => $this->getNo1(),
            "ဆေးကုသမှုပြီးစီးသည့် ဆေးယဉ်ပါးတီဘီလူနာအရေအတွက်" => $this->getNo2(),
            "ကျန်းမာရေးပညာပေး ဟောပြောပွဲ ပြုလုပ်သည့်အကြိမ်အရေအတွက်" => $this->getNo3(),
            "အတူနေမိသားစုဝင်များ/အနေနီးသူများအား တီဘီသံသယလက္ခဏာ စစ်ဆေးသည့်အရေအတွက်" => $this->getNo4(),
            "လူထုအတွင်း တီဘီသံသယလက္ခဏာ စစ်ဆေးသည့်အရေအတွက်" => $this->getNo5(),
            "ကျန်းမာရေးပညာပေးဟောပြောပွဲများ(အားလုံး) ဆောင်ရွက်ရာတွင် တက်ရောက်ခဲ့သူ စုစုပေါင်း" => $this->getNo6(),
            "အတူနေမိသားစုဝင်များ/အနေနီးသူများအား တီဘီသံသယလူနာ ညွှန်းပို့သည့်အရေအတွက်" => $this->getNo7(),
            "လူထုအတွင်း တီဘီသံသယလူနာ ညွှန်းပို့သည့်အရေအတွက်" => $this->getNo8(),
            "စုစုပေါင်း တီဘီသံသယလူနာ ညွှန်းပို့သည့်အရေအတွက်" => $this->getNo9(),
            "ဆေးယဉ်ပါးတီဘီဆေး သောက်ပြီးသူများအား ၂ နှစ်အတွင် းပြန်လည်စစ်ဆေးရန် ညွှန်းပို့သည့် အရေအတွက်" => $this->getNo10(),
        ];
    }

    public function getNo1()
    {
        return [
            "male" => $this->getNo1Data(1),
            "female" => $this->getNo1Data(2)
        ];
    }

    public function getNo1Data($sex)
    {
        return  \App\Models\DOTSPatient::whereHas("dots_visit_report", function ($query) {
            $query->where(["month" => request("month"), "year" => request("year"), "volunteer_id" => request("volunteer_id")]);
        })->whereHas("patient", function ($query) use ($sex) {
            $query->where("sex", $sex);
        })->count();
    }

    public function getNo2()
    {
        return [
            "male" => $this->getNo2Data(1),
            "female" => $this->getNo2Data(2)
        ];
    }

    public function getNo2Data($sex)
    {
        return  \App\Models\Patient::whereHas("dots_patient", function ($query) {
            $query->whereMonth("dots_enddate", request("month"))->whereYear("dots_enddate", request("year"));
            $query->where("volunteer_id", request("volunteer_id"));
        })->whereMonth("finished_date", request("month"))->whereYear("finished_date", request("year"))->where("sex", $sex)->count();
    }

    public function getNo3()
    {
        return \App\Models\HeActivity::where([
            "month" => request("month"),
            "year" => request("year"),
            "volunteer_id" => request("volunteer_id"),
        ])->count();
    }

    public function getNo4()
    {
        return $this->getNo456Data(2);
    }

    public function getNo5()
    {
        return $this->getNo456Data(1);
    }

    public function getNo6()
    {
        return $this->getNo456Data();
    }

    public function getNo456Data($type = null)
    {
        $whereTypes = [
            "month" => request("month"),
            "year" => request("year"),
            "volunteer_id" => request("volunteer_id"),
        ];

        if ($type) $whereTypes["type"] = $type;

        $query = \App\Models\HeActivity::where($whereTypes);

        return [
            "male" => $query->sum("n_o_attendence_male"),
            "female" => $query->sum("n_o_attendence_female"),
        ];
    }

    public function getNo7()
    {
        return [
            "male" => $this->getNo7Data(1),
            "female" => $this->getNo7Data(2)
        ];
    }

    public function getNo7Data($sex)
    {
        return \App\Models\Presumptive::where("case_found_at", 3)->whereMonth("referral_date", request("month"))
            ->whereYear("referral_date", request("year"))->where("volunteer_id", request("volunteer_id"))
            ->where("sex", $sex)->count();
    }

    public function getNo8()
    {
        return [
            "male" => $this->getNo8Data(1),
            "female" => $this->getNo8Data(2)
        ];
    }

    public function getNo8Data($sex)
    {
        return \App\Models\Presumptive::where("case_found_at", 4)->whereMonth("referral_date", request("month"))
            ->whereYear("referral_date", request("year"))->where("volunteer_id", request("volunteer_id"))
            ->where("sex", $sex)->count();
    }

    public function getNo9()
    {
        return [
            "male" => $this->getNo9Data(1),
            "female" => $this->getNo9Data(2)
        ];
    }

    public function getNo9Data($sex)
    {
        return \App\Models\Presumptive::where("case_found_at", "!=", 5)->whereMonth("referral_date", request("month"))
            ->whereYear("referral_date", request("year"))->where("volunteer_id", request("volunteer_id"))
            ->where("sex", $sex)->count();
    }

    public function getNo10()
    {
        return [
            "male" => $this->getNo10Data(1),
            "female" => $this->getNo10Data(2)
        ];
    }

    public function getNo10Data($sex)
    {
        return \App\Models\Presumptive::where("case_found_at", 5)->whereMonth("referral_date", request("month"))
            ->whereYear("referral_date", request("year"))->where("volunteer_id", request("volunteer_id"))
            ->where("sex", $sex)->count();
    }
}
