<?php

namespace App\Service\Dashboard;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Collection;
use Carbon\Carbon;

class Volunteer extends CustomClassContainer
{

    function __construct()
    {
        parent::__construct(new \App\Models\Volunteer());
    }



    public function withColumn()
    {
        $this->model = $this->model->with([
           
            "township","he_activity",
            "trainings" => function ($query) {
                $query->where("status", 1);
            },
            
        ]);
    
        
        // "dots_patient"=> function ($query) {
        //         $query->where("status", 1);
        //     },
        //     "dots_visit_report" => function ($query) {
        //         $query->where("status", 1)->latest()->limit(1);
        //     },
        //     "dots_visit_date" => function ($query) {
        //         $query->where("status", 1) ->latest()->limit(1);
        //     },
    }

    public function getEach($column = null, $value = null)
    {
        $this->withColumn();
        return $this->model->where($column, $value)->first();
    }


    public function getAll($data)
    {
        $this->withColumn();
        $this->filter(["name", "code", "id", "township_id"], $data);
        if (request("search")) {
            $this->model = $this->model->where(function ($query) {
                $query->where("name", "like", request("search") . "%")->orWhere("code", "like", request("search") . "%")->orWhere("code", "like", request("search") . "%");
            });
        }

        if (request("startDate") && request("endDate")) {
            $this->model = $this->model->whereHas("trainings", function ($query) {
                $query->whereBetween("date", [request("startDate"), request("endDate")]);
                if (request("training_type_id")) {
                    $query->where("training_type_id", request('training_type_id'));
                }
                if (request("type")) {
                    $query->where("type", request('type'));
                }
                 if (request("township_id")) {
                    return $this->model->where("status", 1)
                    ->where("township_id",request("township_id"));
                }
                $query->where("status", 1);
            });
        }
        
        if (request("dotsfromDate") && request("dotstoDate")) {
           
        $dotsFromDate=request("dotsfromDate");
        $dotsToDate=request("dotstoDate");
        
        $fromMonth = Carbon::createFromFormat('Y-m-d', $dotsFromDate)->format('m');
        $toMonth = Carbon::createFromFormat('Y-m-d', $dotsToDate)->format('m');
        $fromYear = Carbon::createFromFormat('Y-m-d', $dotsFromDate)->format('Y');
        $toYear = Carbon::createFromFormat('Y-m-d', $dotsToDate)->format('Y');
        $reported_volunteers=[];
        if (request("township_id")) {
            $volunteers=$this->model->where("status", 1)
                           ->where("township_id",request("township_id"))
                           ->get();
           }
        foreach ($volunteers as $vol) {
            
            // check he 
            $heCounts = \App\Models\HeActivity::where("volunteer_id", $vol->id)
            ->whereBetween("date", [$dotsFromDate,$dotsToDate])->count();
                            
                if ($heCounts > 0) {
                    array_push($reported_volunteers,$vol);
                }
                else{
                // check dots
                $noappDotsCount = \App\Models\DotsVisitReport::where("volunteer_id", $vol->id)
                                    ->where(function ($subQuery) use ($fromMonth, $fromYear) {
                                        $subQuery->where('year', '>', $fromYear)
                                                ->orWhere(function ($q) use ($fromMonth, $fromYear) {
                                                    $q->where('year', '=', $fromYear)
                                                    ->where('month', '>=', $fromMonth);
                                                });
                                    })->where(function ($subQuery) use ($toMonth, $toYear) {
                                        $subQuery->where('year', '<', $toYear)
                                                ->orWhere(function ($q) use ($toMonth, $toYear) {
                                                    $q->where('year', '=', $toYear)
                                                    ->where('month', '<=', $toMonth);
                                                });
                                    })->count();
                $appDotsCount = \App\Models\DotsVisitDate::where("volunteer_id", $vol->id)
                                    ->whereBetween("date", [$dotsFromDate,$dotsToDate])
                                    ->count();
                //check presumptive
                $ppCount = \App\Models\Presumptive::where("volunteer_id", $vol->id)
                            ->whereBetween("referral_date", [$dotsFromDate,$dotsToDate])
                            ->count();
                            
                if ($noappDotsCount > 0) {
                    array_push($reported_volunteers,$vol);
                } 
                if($appDotsCount > 0){
                    array_push($reported_volunteers,$vol);
                }
                if ($ppCount > 0) {
                    array_push($reported_volunteers,$vol);
                }
                
            }
        }

        return $reported_volunteers;
        
        }
        
        return $this->model->where("status", 1)->get();
    }

    public function trash($data)
    {
        $this->withColumn();
        $this->filter(["name", "code"], $data);
        return $this->model->where("status", 0)->get();
    }
}
